/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.TimeseriesMetaOptions;
import com.alicloud.openservices.tablestore.model.TimeseriesTableOptions;
import java.util.ArrayList;
import java.util.List;

public class TimeseriesTableMeta
implements Jsonizable {
    private String timeseriesTableName;
    private TimeseriesTableOptions timeseriesTableOptions;
    private TimeseriesMetaOptions timeseriesMetaOptions;
    private String status;
    private final List<String> timeseriesKeys = new ArrayList<String>();
    private final List<PrimaryKeySchema> fieldPrimaryKeys = new ArrayList<PrimaryKeySchema>();

    public TimeseriesTableMeta(String timeseriesTableName) {
        this(timeseriesTableName, new TimeseriesTableOptions());
    }

    public TimeseriesTableMeta(String timeseriesTableName, TimeseriesTableOptions timeseriesTableOptions) {
        Preconditions.checkArgument(timeseriesTableName != null && !timeseriesTableName.isEmpty(), "The name of table should not be null or empty.");
        this.setTimeseriesTableName(timeseriesTableName);
        this.setTimeseriesTableOptions(timeseriesTableOptions);
    }

    public TimeseriesTableMeta(String timeseriesTableName, TimeseriesTableOptions timeseriesTableOptions, String status) {
        Preconditions.checkArgument(timeseriesTableName != null && !timeseriesTableName.isEmpty(), "The name of table should not be null or empty.");
        this.setTimeseriesTableName(timeseriesTableName);
        this.setTimeseriesTableOptions(timeseriesTableOptions);
        this.setStatus(status);
    }

    public void setTimeseriesTableName(String timeseriesTableName) {
        Preconditions.checkArgument(timeseriesTableName != null && !timeseriesTableName.isEmpty(), "The name of table should not be null or empty.");
        this.timeseriesTableName = timeseriesTableName;
    }

    public String getTimeseriesTableName() {
        return this.timeseriesTableName;
    }

    public void setTimeseriesTableOptions(TimeseriesTableOptions timeseriesTableOptions) {
        Preconditions.checkNotNull(timeseriesTableOptions, "TimeseriesTableOptions should not be null.");
        this.timeseriesTableOptions = timeseriesTableOptions;
    }

    public TimeseriesTableOptions getTimeseriesTableOptions() {
        return this.timeseriesTableOptions;
    }

    public TimeseriesMetaOptions getTimeseriesMetaOptions() {
        return this.timeseriesMetaOptions;
    }

    public void setTimeseriesMetaOptions(TimeseriesMetaOptions timeseriesMetaOptions) {
        Preconditions.checkNotNull(timeseriesMetaOptions, "TimeseriesMetaOptions should not be null.");
        this.timeseriesMetaOptions = timeseriesMetaOptions;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void addTimeseriesKey(String primaryKey) {
        this.timeseriesKeys.add(primaryKey);
    }

    public List<String> getTimeseriesKeys() {
        return this.timeseriesKeys;
    }

    public void addFieldPrimaryKey(String name, PrimaryKeyType type) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key field should not be null or empty.");
        Preconditions.checkNotNull(type, "The type of primary key field should not be null.");
        this.fieldPrimaryKeys.add(new PrimaryKeySchema(name, type));
    }

    public List<PrimaryKeySchema> getFieldPrimaryKeys() {
        return this.fieldPrimaryKeys;
    }

    public String toString() {
        String s = "TimeseriesTableName: " + this.timeseriesTableName;
        return s;
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append('{');
        sb.append(newline);
        sb.append("\"TimeseriesTableName\": \"");
        sb.append(this.timeseriesTableName);
        sb.append('\"');
        sb.append("}");
    }
}

