/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;

public class TimeseriesTableOptions
implements Jsonizable {
    private OptionalValue<Integer> timeToLive = new OptionalValue("TimeToLive");

    public TimeseriesTableOptions() {
    }

    public TimeseriesTableOptions(int timeToLive) {
        this.setTimeToLive(timeToLive);
    }

    public int getTimeToLive() {
        if (!this.timeToLive.isValueSet()) {
            throw new IllegalStateException("The value of TimeToLive is not set.");
        }
        return this.timeToLive.getValue();
    }

    public void setTimeToLive(int timeToLive) {
        Preconditions.checkArgument(timeToLive > 0 || timeToLive == -1, "The value of timeToLive can be -1 or any positive value.");
        this.timeToLive.setValue(timeToLive);
    }

    public boolean hasSetTimeToLive() {
        return this.timeToLive.isValueSet();
    }

    public String toString() {
        return this.timeToLive.toString();
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append("{");
        this.jsonizeFields(sb, true);
        sb.append("}");
    }

    protected boolean jsonizeFields(StringBuilder sb, boolean firstItem) {
        if (this.timeToLive.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"TimeToLive\": ");
            sb.append(this.timeToLive.getValue());
        }
        return firstItem;
    }
}

