/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

public class FieldValueFactorFunction {
    private String fieldName;
    private Float factor;
    private FunctionModifier modifier;
    private Double missing;

    public FieldValueFactorFunction() {
    }

    public FieldValueFactorFunction(String fieldName, Float factor, FunctionModifier modifier, Double missing) {
        this.fieldName = fieldName;
        this.factor = factor;
        this.modifier = modifier;
        this.missing = missing;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Float getFactor() {
        return this.factor;
    }

    public void setFactor(Float factor) {
        this.factor = factor;
    }

    public FunctionModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(FunctionModifier modifier) {
        this.modifier = modifier;
    }

    public Double getMissing() {
        return this.missing;
    }

    public void setMissing(Double missing) {
        this.missing = missing;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum FunctionModifier {
        UNKNOWN,
        NONE,
        LOG,
        LOG1P,
        LOG2P,
        LN,
        LN1P,
        LN2P,
        SQUARE,
        SQRT,
        RECIPROCAL;

    }

    public static final class Builder {
        private String fieldName;
        private Float factor;
        private FunctionModifier modifier;
        private Double missing;

        private Builder() {
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Float factor() {
            return this.factor;
        }

        public Builder factor(float factor) {
            this.factor = Float.valueOf(factor);
            return this;
        }

        public FunctionModifier modifier() {
            return this.modifier;
        }

        public Builder modifier(FunctionModifier modifier) {
            this.modifier = modifier;
            return this;
        }

        public Double missing() {
            return this.missing;
        }

        public Builder missing(double missing) {
            this.missing = missing;
            return this;
        }

        public FieldValueFactorFunction build() {
            FieldValueFactorFunction fieldValueFactorFunction = new FieldValueFactorFunction();
            fieldValueFactorFunction.setFieldName(this.fieldName);
            fieldValueFactorFunction.setFactor(this.factor);
            fieldValueFactorFunction.setModifier(this.modifier);
            fieldValueFactorFunction.setMissing(this.missing);
            return fieldValueFactorFunction;
        }
    }
}

