/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.tunnel;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.DataBlockType;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BulkExportQueryCriteria {
    private String tableName;
    private PrimaryKey inclusiveStartPrimaryKey;
    private PrimaryKey exclusiveEndPrimaryKey;
    private Set<String> columnsToGet = new HashSet<String>();
    private OptionalValue<Filter> filter = new OptionalValue("Filter");
    private DataBlockType dataBlockType = DataBlockType.DBT_SIMPLE_ROW_MATRIX;

    public BulkExportQueryCriteria(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public void setDataBlockType(DataBlockType dataBlockType) {
        Preconditions.checkArgument(dataBlockType == DataBlockType.DBT_PLAIN_BUFFER || dataBlockType == DataBlockType.DBT_SIMPLE_ROW_MATRIX, "Unknown DataBlockType.");
        this.dataBlockType = dataBlockType;
    }

    public DataBlockType getDataBlockType() {
        return this.dataBlockType;
    }

    public PrimaryKey getInclusiveStartPrimaryKey() {
        return this.inclusiveStartPrimaryKey;
    }

    public void setInclusiveStartPrimaryKey(PrimaryKey inclusiveStartPrimaryKey) {
        Preconditions.checkArgument(inclusiveStartPrimaryKey != null && !inclusiveStartPrimaryKey.isEmpty(), "The inclusive start primary key should not be null.");
        this.inclusiveStartPrimaryKey = inclusiveStartPrimaryKey;
    }

    public PrimaryKey getExclusiveEndPrimaryKey() {
        return this.exclusiveEndPrimaryKey;
    }

    public void setExclusiveEndPrimaryKey(PrimaryKey exclusiveEndPrimaryKey) {
        Preconditions.checkArgument(exclusiveEndPrimaryKey != null && !exclusiveEndPrimaryKey.isEmpty(), "The exclusive end primary key should not be null.");
        this.exclusiveEndPrimaryKey = exclusiveEndPrimaryKey;
    }

    public void setTableName(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Set<String> getColumnsToGet() {
        return Collections.unmodifiableSet(this.columnsToGet);
    }

    public void addColumnsToGet(String columnName) {
        Preconditions.checkArgument(columnName != null && !columnName.isEmpty(), "Column's name should not be null or empty.");
        this.columnsToGet.add(columnName);
    }

    public void addColumnsToGet(String[] columnNames) {
        Preconditions.checkNotNull(columnNames, "columnNames should not be null.");
        for (int i = 0; i < columnNames.length; ++i) {
            this.addColumnsToGet(columnNames[i]);
        }
    }

    public void addColumnsToGet(Collection<String> columnsToGet) {
        this.columnsToGet.addAll(columnsToGet);
    }

    public void clearColumnsToGet() {
        this.columnsToGet.clear();
    }

    public int numColumnsToGet() {
        return this.columnsToGet.size();
    }

    public void setFilter(Filter filter) {
        Preconditions.checkNotNull(filter, "The filter should not be null");
        this.filter.setValue(filter);
    }

    public Filter getFilter() {
        if (!this.filter.isValueSet()) {
            throw new IllegalStateException("The value of filter is not set.");
        }
        return this.filter.getValue();
    }

    public boolean hasSetFilter() {
        return this.filter.isValueSet();
    }

    public void copyTo(BulkExportQueryCriteria target) {
        target.setTableName(this.tableName);
        target.columnsToGet.addAll(this.columnsToGet);
        target.setDataBlockType(this.dataBlockType);
        target.setInclusiveStartPrimaryKey(this.inclusiveStartPrimaryKey);
        target.setExclusiveEndPrimaryKey(this.exclusiveEndPrimaryKey);
        if (this.filter.isValueSet()) {
            target.filter.setValue(this.filter.getValue());
        }
    }
}

