/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.core;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.timeline.TimelineMetaStore;
import com.alicloud.openservices.tablestore.timeline.TimelineStore;
import com.alicloud.openservices.tablestore.timeline.TimelineStoreFactory;
import com.alicloud.openservices.tablestore.timeline.core.TimelineMetaStoreImpl;
import com.alicloud.openservices.tablestore.timeline.core.TimelineStoreImpl;
import com.alicloud.openservices.tablestore.timeline.model.TimelineMetaSchema;
import com.alicloud.openservices.tablestore.timeline.model.TimelineSchema;
import com.alicloud.openservices.tablestore.timeline.utils.Preconditions;

public class TimelineStoreFactoryImpl
implements TimelineStoreFactory {
    private SyncClient client;

    public TimelineStoreFactoryImpl(SyncClient client) {
        Preconditions.checkNotNull(client, "SyncClient should not be null.");
        this.client = client;
    }

    @Override
    public TimelineStore createTimelineStore(TimelineSchema timelineSchema) {
        Preconditions.checkNotNull(timelineSchema, "TimelineSchema should not be null.");
        return new TimelineStoreImpl(this.client, timelineSchema);
    }

    @Override
    public TimelineMetaStore createMetaStore(TimelineMetaSchema metaSchema) {
        Preconditions.checkNotNull(metaSchema, "TimelineMetaSchema should not be null.");
        return new TimelineMetaStoreImpl(this.client, metaSchema);
    }
}

