/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.model;

import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.timeline.utils.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TimelineIdentifier {
    private List<PrimaryKeyColumn> fields;

    private TimelineIdentifier(List<PrimaryKeyColumn> fields) {
        Preconditions.checkArgument(fields != null && fields.size() != 0, "The keys of identifier is null or empty.");
        this.fields = fields;
    }

    public List<PrimaryKeyColumn> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public PrimaryKeyColumn getField(int index) {
        return this.fields.get(index);
    }

    public String toString() {
        return this.fields.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimelineIdentifier)) {
            return false;
        }
        TimelineIdentifier id = (TimelineIdentifier)o;
        if (this.fields.size() != id.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).equals(id.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.fields == null) {
            return 0;
        }
        int result = 1;
        for (PrimaryKeyColumn field : this.fields) {
            result = 31 * result + (field == null ? 0 : field.hashCode());
        }
        return result;
    }

    public static class Builder {
        private List<PrimaryKeyColumn> fields = new ArrayList<PrimaryKeyColumn>(3);

        public Builder addField(String name, String value) {
            this.fields.add(new PrimaryKeyColumn(name, PrimaryKeyValue.fromString(value)));
            return this;
        }

        public Builder addField(String name, long value) {
            this.fields.add(new PrimaryKeyColumn(name, PrimaryKeyValue.fromLong(value)));
            return this;
        }

        public Builder addField(String name, byte[] value) {
            this.fields.add(new PrimaryKeyColumn(name, PrimaryKeyValue.fromBinary(value)));
            return this;
        }

        public Builder addField(PrimaryKeyColumn column) {
            this.fields.add(column);
            return this;
        }

        public TimelineIdentifier build() {
            TimelineIdentifier id = new TimelineIdentifier(this.fields);
            this.fields = null;
            return id;
        }
    }
}

