/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.worker;

import com.alicloud.openservices.tablestore.model.tunnel.ChannelStatus;
import com.alicloud.openservices.tablestore.model.tunnel.internal.Channel;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelConnect;
import com.alicloud.openservices.tablestore.tunnel.worker.TunnelStateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedChannelConnect
implements IChannelConnect {
    private static final Logger LOG = LoggerFactory.getLogger(FailedChannelConnect.class);
    private TunnelStateMachine stateMachine;
    private Channel currentChannel;

    public FailedChannelConnect(TunnelStateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public Channel getCurrentChannel() {
        return this.currentChannel;
    }

    public void setCurrentChannel(Channel currentChannel) {
        this.currentChannel = currentChannel;
    }

    @Override
    public synchronized void notifyStatus(Channel channel) {
        if (this.currentChannel != null && this.currentChannel.getVersion() > channel.getVersion()) {
            return;
        }
        this.currentChannel = new Channel(channel);
        switch (this.currentChannel.getStatus()) {
            case CLOSE: {
                break;
            }
            case CLOSING: 
            case OPEN: {
                this.currentChannel.setVersion(this.currentChannel.getVersion() + 1L);
                this.currentChannel.setStatus(ChannelStatus.CLOSE);
                this.stateMachine.updateStatus(this.currentChannel);
                break;
            }
            case TERMINATED: {
                break;
            }
            default: {
                LOG.error("unexpected channel status {}, channelId: {}", (Object)this.currentChannel.getStatus().name(), (Object)this.currentChannel.getChannelId());
            }
        }
    }

    @Override
    public synchronized boolean closed() {
        if (this.currentChannel == null) {
            return false;
        }
        return this.currentChannel.getStatus().equals((Object)ChannelStatus.CLOSE) || this.currentChannel.getStatus().equals((Object)ChannelStatus.TERMINATED);
    }

    @Override
    public void close() {
    }
}

