/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.dispatch;

import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.dispatch.BaseDispatcher;
import java.util.concurrent.atomic.AtomicLong;

public class RoundRobinDispatcher
extends BaseDispatcher {
    private AtomicLong counter = new AtomicLong(0L);
    private int bucketCount;

    public RoundRobinDispatcher(int bucketCount) {
        super(bucketCount);
        this.bucketCount = bucketCount;
    }

    @Override
    public int getDispatchIndex(RowChange rowChange) {
        int bucketIndex = (int)this.counter.getAndIncrement() % this.bucketCount;
        this.addBucketCount(bucketIndex);
        return bucketIndex;
    }
}

