/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class SysException
extends RuntimeException {
    private static final long serialVersionUID = -9183281406145817016L;
    private Stack<Exception> myErrors = null;

    private static void printNestedErrorStack(SysException e) {
        Stack<Exception> errors = e.getErrors();
        while (errors != null && !errors.empty()) {
            System.err.println("Nested exception is: ");
            Exception nxt = errors.pop();
            if (nxt instanceof SysException) {
                SysException se = (SysException)nxt;
                nxt.printStackTrace();
                SysException.printNestedErrorStack(se);
                continue;
            }
            nxt.printStackTrace();
        }
    }

    private static void addStackTraceElementsToList(StackTraceElement[] elements, List<StackTraceElement> list) {
        for (int i = 0; i < elements.length; ++i) {
            list.add(elements[i]);
        }
    }

    public SysException(String msg) {
        super(msg);
        this.myErrors = new Stack();
    }

    public SysException(String msg, Throwable cause) {
        super(msg, cause);
        this.myErrors = new Stack();
    }

    public SysException(String msg, Stack<Exception> nestedList) {
        super(msg);
        this.myErrors = (Stack)nestedList.clone();
    }

    private void addStackTraceToList(List<StackTraceElement> list) {
        StackTraceElement[] elements = super.getStackTrace();
        SysException.addStackTraceElementsToList(elements, list);
        Stack<Exception> errors = this.getErrors();
        while (errors != null && !errors.empty()) {
            Exception e = errors.pop();
            if (e instanceof SysException) {
                SysException se = (SysException)e;
                se.addStackTraceToList(list);
                continue;
            }
            elements = e.getStackTrace();
            SysException.addStackTraceElementsToList(elements, list);
        }
    }

    public Stack<Exception> getErrors() {
        if (this.myErrors == null) {
            return null;
        }
        return (Stack)this.myErrors.clone();
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        SysException.printNestedErrorStack(this);
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        this.addStackTraceToList(elements);
        return elements.toArray(new StackTraceElement[0]);
    }
}

