/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.internals.ConfigServiceLocator;
import com.ctrip.framework.apollo.internals.DefaultConfigManager;
import com.ctrip.framework.apollo.internals.Injector;
import com.ctrip.framework.apollo.internals.RemoteConfigLongPollService;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigFactoryManager;
import com.ctrip.framework.apollo.spi.ConfigRegistry;
import com.ctrip.framework.apollo.spi.DefaultConfigFactory;
import com.ctrip.framework.apollo.spi.DefaultConfigFactoryManager;
import com.ctrip.framework.apollo.spi.DefaultConfigRegistry;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.apollo.util.http.HttpUtil;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Singleton;

public class DefaultInjector
implements Injector {
    private com.google.inject.Injector m_injector;

    public DefaultInjector() {
        try {
            this.m_injector = Guice.createInjector((Module[])new Module[]{new ApolloModule()});
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException("Unable to initialize Guice Injector!", ex);
            Tracer.logError((Throwable)exception);
            throw exception;
        }
    }

    @Override
    public <T> T getInstance(Class<T> clazz) {
        try {
            return (T)this.m_injector.getInstance(clazz);
        }
        catch (Throwable ex) {
            Tracer.logError((Throwable)ex);
            throw new ApolloConfigException(String.format("Unable to load instance for %s!", clazz.getName()), ex);
        }
    }

    @Override
    public <T> T getInstance(Class<T> clazz, String name) {
        return null;
    }

    private static class ApolloModule
    extends AbstractModule {
        private ApolloModule() {
        }

        protected void configure() {
            this.bind(ConfigManager.class).to(DefaultConfigManager.class).in(Singleton.class);
            this.bind(ConfigFactoryManager.class).to(DefaultConfigFactoryManager.class).in(Singleton.class);
            this.bind(ConfigRegistry.class).to(DefaultConfigRegistry.class).in(Singleton.class);
            this.bind(ConfigFactory.class).to(DefaultConfigFactory.class).in(Singleton.class);
            this.bind(ConfigUtil.class).in(Singleton.class);
            this.bind(HttpUtil.class).in(Singleton.class);
            this.bind(ConfigServiceLocator.class).in(Singleton.class);
            this.bind(RemoteConfigLongPollService.class).in(Singleton.class);
        }
    }
}

