/*
 * Decompiled with CFR 0.152.
 */
package com.rudikershaw.gitbuildhook.hook.type;

import java.util.Arrays;

public enum GitHookType {
    PRE_COMMIT("pre-commit"),
    PRE_MERGE_COMMIT("pre-merge-commit"),
    PRE_PUSH("pre-push"),
    PRE_REBASE("pre-rebase"),
    COMMIT_MSG("commit-msg"),
    PREPARE_COMMIT_MSG("prepare-commit-msg"),
    UPDATE("update"),
    POST_UPDATE("post-update"),
    APPLYPATCH_MSG("applypatch-msg"),
    PRE_APPLYPATCH("pre-applypatch"),
    POST_MERGE("post-merge"),
    POST_APPLYPATCH("post-applypatch"),
    POST_COMMIT("post-commit"),
    POST_CHECKOUT("post-checkout"),
    PRE_RECEIVE("pre-receive"),
    PROC_RECEIVE("proc-receive"),
    POST_RECEIVE("post-receive"),
    REFERENCE_TRANSACTION("reference-transaction"),
    PUSH_TO_CHECKOUT("push-to-checkout"),
    PRE_AUTO_GC("pre-auto-gc"),
    POST_REWRITE("post-rewrite"),
    SENDEMAIL_VALIDATE("sendemail-validate"),
    FSMONITOR_WATCHMAN("fsmonitor-watchman"),
    P4_CHANGELIST("p4-changelist"),
    P4_PREPARE_CHANGELIST("p4-prepare-changelist"),
    P4_POST_CHANGELIST("p4-post-changelist"),
    P4_PRE_SUBMIT("p4-pre-submit"),
    POST_INDEX_CHANGE("post-index-change");

    private final String hookFileName;

    private GitHookType(String fileName) {
        this.hookFileName = fileName;
    }

    public String getHookFileName() {
        return this.hookFileName;
    }

    public static boolean isValidHookName(String filename) {
        return Arrays.stream(GitHookType.values()).anyMatch(h -> h.getHookFileName().equals(filename));
    }
}

