/*
 * Decompiled with CFR 0.152.
 */
package com.rudikershaw.gitbuildhook.validation;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public interface GitRepositoryValidator {
    default public void validateGitRepository(MavenProject project) throws MojoFailureException {
        if (!this.isGitRepoInitialised(project)) {
            this.failBuildBecauseRepoCouldNotBeFound(null);
        }
    }

    default public boolean isGitRepoInitialised(MavenProject project) {
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        repoBuilder.findGitDir(project.getBasedir());
        return repoBuilder.getGitDir() != null;
    }

    default public void failBuildBecauseRepoCouldNotBeFound(Exception e) throws MojoFailureException {
        String message = "Could not find or initialise a local git repository. A repository is required.";
        throw new MojoFailureException("Could not find or initialise a local git repository. A repository is required.", (Throwable)e);
    }
}

