/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.tencentcloudapi.common.exception.TencentCloudSDKException;

public class Credential {
    private String secretId;
    private String secretKey;
    private String token;
    private Updater updater;

    public Credential() {
    }

    public Credential(String secretId, String secretKey) {
        this(secretId, secretKey, "");
    }

    public Credential(String secretId, String secretKey, String token) {
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.token = token;
    }

    public Credential(String secretId, String secretKey, String token, Updater updater) {
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.token = token;
        this.updater = updater;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    public String getSecretId() {
        this.tryUpdate();
        return this.secretId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretKey() {
        this.tryUpdate();
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getToken() {
        this.tryUpdate();
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    private void tryUpdate() {
        if (this.updater == null) {
            return;
        }
        try {
            this.updater.update(this);
        }
        catch (TencentCloudSDKException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Updater {
        public void update(Credential var1) throws TencentCloudSDKException;
    }
}

