/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.store.impl;

import com.xxl.sso.core.model.LoginInfo;
import com.xxl.sso.core.store.LoginStore;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.response.Response;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LocalLoginStore
implements LoginStore {
    private final ConcurrentMap<String, LoginInfo> loginStore = new ConcurrentHashMap<String, LoginInfo>();

    private String parseStoreKey(String userId) {
        return userId;
    }

    @Override
    public Response<String> set(LoginInfo loginInfo) {
        if (loginInfo == null || StringTool.isBlank((String)loginInfo.getUserId()) || StringTool.isBlank((String)loginInfo.getSignature())) {
            return Response.ofFail((String)"loginInfo invalid.");
        }
        if (loginInfo.getExpireTime() < System.currentTimeMillis()) {
            return Response.ofFail((String)"expireTime invalid.");
        }
        String storeKey = this.parseStoreKey(loginInfo.getUserId());
        this.loginStore.put(storeKey, loginInfo);
        return Response.ofSuccess();
    }

    @Override
    public Response<String> update(LoginInfo loginInfo) {
        if (loginInfo == null || StringTool.isBlank((String)loginInfo.getUserId())) {
            return Response.ofFail((String)"loginInfo invalid.");
        }
        String storeKey = this.parseStoreKey(loginInfo.getUserId());
        if (loginInfo.getExpireTime() < System.currentTimeMillis()) {
            return Response.ofFail((String)"expireTime invalid.");
        }
        LoginInfo loginInfoStore = (LoginInfo)this.loginStore.get(storeKey);
        if (loginInfoStore == null) {
            return Response.ofFail((String)"loginInfo not exists.");
        }
        loginInfoStore.setUserName(loginInfo.getUserName());
        loginInfoStore.setRealName(loginInfo.getRealName());
        loginInfoStore.setExtraInfo(loginInfo.getExtraInfo());
        loginInfoStore.setRoleList(loginInfo.getRoleList());
        loginInfoStore.setPermissionList(loginInfo.getPermissionList());
        loginInfoStore.setExpireTime(loginInfo.getExpireTime());
        this.loginStore.put(storeKey, loginInfoStore);
        return Response.ofSuccess();
    }

    @Override
    public Response<String> remove(String userId) {
        if (StringTool.isBlank((String)userId)) {
            return Response.ofFail((String)"userId invalid.");
        }
        String storeKey = this.parseStoreKey(userId);
        this.loginStore.remove(storeKey);
        return Response.ofSuccess();
    }

    @Override
    public Response<LoginInfo> get(String userId) {
        if (StringTool.isBlank((String)userId)) {
            return Response.ofFail((String)"userId invalid.");
        }
        String storeKey = this.parseStoreKey(userId);
        LoginInfo loginInfo = (LoginInfo)this.loginStore.get(storeKey);
        if (loginInfo == null) {
            return Response.ofFail((String)"loginInfo not exists.");
        }
        if (loginInfo.getExpireTime() < System.currentTimeMillis()) {
            this.loginStore.remove(storeKey);
            return Response.ofFail((String)"loginInfo is timeout");
        }
        return Response.ofSuccess((Object)loginInfo);
    }
}

