/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.yop.sdk.exception.YopHttpException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.utils.HttpUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;

public class YopJsonResponseAnalyzer
implements HttpResponseAnalyzer {
    private static final YopJsonResponseAnalyzer INSTANCE = new YopJsonResponseAnalyzer();

    public static YopJsonResponseAnalyzer getInstance() {
        return INSTANCE;
    }

    protected YopJsonResponseAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        String content = context.getResponse().readContent();
        if (!HttpUtils.isJsonResponse(response.getMetadata().getContentType())) {
            throw new YopHttpException("ResponseError, Need Json, contentType:" + response.getMetadata().getContentType() + ", content:" + content + ", resource:" + context.getOriginRequest().getEndpoint() + "/" + context.getOriginRequest().getResourcePath());
        }
        if (null != content) {
            JsonUtils.load(content, response);
        }
        return true;
    }
}

