/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopResponseMetadata;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.utils.ClientUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSignatureCheckAnalyzer
implements HttpResponseAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSignatureCheckAnalyzer.class);
    private static final YopSignatureCheckAnalyzer INSTANCE = new YopSignatureCheckAnalyzer();

    public static YopSignatureCheckAnalyzer getInstance() {
        return INSTANCE;
    }

    private YopSignatureCheckAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        YopResponseMetadata metadata = response.getMetadata();
        if (BooleanUtils.isTrue((Boolean)context.isSkipVerifySign()) || StringUtils.isBlank((CharSequence)metadata.getYopSign())) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("response sign verify begin, requestId:{}, sign:{}", (Object)metadata.getYopRequestId(), (Object)metadata.getYopSign());
        }
        SignOptions reqOptions = context.getSignOptions();
        YopPlatformCredentials platformCredentials = this.getPlatformCredential(context.getProvider(), context.getEnv(), reqOptions, context.getAppKey(), metadata.getYopCertSerialNo(), ((BaseRequest)context.getOriginRequest().getOriginalRequestObject()).getRequestConfig().getServerRoot());
        if (null == platformCredentials) {
            throw new YopClientException("ConfigProblem, YopPlatformCredentials NotFound, appKey:" + context.getAppKey() + ", serialNo:" + metadata.getYopCertSerialNo());
        }
        context.getSigner().checkSignature(context.getResponse(), metadata.getYopSign(), (YopCredentials<?>)platformCredentials, new SignOptions().withDigestAlg(reqOptions.getDigestAlg()).withProtocolPrefix(reqOptions.getProtocolPrefix()).withExpirationInSeconds(reqOptions.getExpirationInSeconds()).withUrlSafe(!StringUtils.containsAny((CharSequence)metadata.getYopSign(), (char[])new char[]{'+', '/', '='})));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("response sign verify success, requestId:{}, sign:{}", (Object)metadata.getYopRequestId(), (Object)metadata.getYopSign());
        }
        return false;
    }

    private YopPlatformCredentials getPlatformCredential(String provider, String env, SignOptions signOptions, String appKey, String serialNo, String serverRoot) {
        CertTypeEnum certType;
        CertTypeEnum certTypeEnum = certType = "YOP-SM2-SM3".equals(signOptions.getProtocolPrefix()) ? CertTypeEnum.SM2 : CertTypeEnum.RSA2048;
        if (certType == CertTypeEnum.RSA2048) {
            if (StringUtils.isNotBlank((CharSequence)serialNo)) {
                LOGGER.warn("rsa signed request not need serialNo:{}.", (Object)serialNo);
            }
            serialNo = "rsa";
        }
        return ClientUtils.getCurrentPlatformCredentialsProvider().getCredentials(provider, env, appKey, serialNo, serverRoot);
    }
}

