/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.callback.handler;

import com.yeepay.yop.sdk.service.common.callback.handler.YopCallbackHandler;
import com.yeepay.yop.sdk.service.common.callback.handler.impl.YopWildCardCallbackHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class YopCallbackHandlerFactory {
    private static final Map<String, YopCallbackHandler> YOP_CALLBACK_HANDLERS = new ConcurrentHashMap<String, YopCallbackHandler>();

    public static YopCallbackHandler getHandler(String type) {
        assert (StringUtils.isNotEmpty((CharSequence)type));
        YopCallbackHandler handler = YOP_CALLBACK_HANDLERS.get(type);
        if (null == handler) {
            return YOP_CALLBACK_HANDLERS.get("default");
        }
        return handler;
    }

    public static void register(String eventType, YopCallbackHandler yopCallbackHandler) {
        assert (StringUtils.isNotEmpty((CharSequence)eventType));
        assert (null != yopCallbackHandler);
        YOP_CALLBACK_HANDLERS.put(eventType, yopCallbackHandler);
    }

    static {
        YopCallbackHandlerFactory.register("default", new YopWildCardCallbackHandler());
    }
}

