/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.inter.utils;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.utils.Encodes;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Map;
import javax.crypto.Cipher;

public class RSA {
    static final Map<DigestAlgEnum, String> SIGN_ALG_MAP = Maps.newHashMap();

    public static boolean verifySign(byte[] data, byte[] sign, PublicKey publicKey, DigestAlgEnum digestAlg) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALG_MAP.get(digestAlg));
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (Exception e) {
            throw new YopClientException("SystemError, Sign Fail, key:" + publicKey + ", digestAlg" + digestAlg + "ex:", (Throwable)e);
        }
    }

    public static boolean verifySign(String data, String sign, PublicKey pubicKey, DigestAlgEnum digestAlg) {
        byte[] dataByte = data.getBytes(Charsets.UTF_8);
        byte[] signByte = Encodes.decodeBase64((String)sign);
        return RSA.verifySign(dataByte, signByte, pubicKey, digestAlg);
    }

    public static byte[] sign(byte[] data, PrivateKey key, DigestAlgEnum digestAlg) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALG_MAP.get(digestAlg));
            signature.initSign(key);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new YopClientException("SystemError, Sign Fail, key:" + key + ", digestAlg" + digestAlg + "ex:", (Throwable)e);
        }
    }

    public static String sign(String data, PrivateKey key, DigestAlgEnum digestAlg) {
        return RSA.sign(data, key, digestAlg, null);
    }

    public static String sign(String data, PrivateKey key, DigestAlgEnum digestAlg, SignOptions options) {
        byte[] dataByte = data.getBytes(Charsets.UTF_8);
        if (null != options && !options.isUrlSafe()) {
            return Encodes.encodeBase64((byte[])RSA.sign(dataByte, key, digestAlg));
        }
        return Encodes.encodeUrlSafeBase64((byte[])RSA.sign(dataByte, key, digestAlg));
    }

    public static byte[] encrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new YopClientException("SystemError, Encrypt Fail, key:" + key + "ex:", (Throwable)e);
        }
    }

    public static String encryptToBase64(String data, Key key) {
        try {
            return Encodes.encodeUrlSafeBase64((byte[])RSA.encrypt(data.getBytes(Charsets.UTF_8), key));
        }
        catch (Exception e) {
            throw new YopClientException("SystemError, Encrypt Fail, data:" + data + ", key:" + key + "ex:", (Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new YopClientException("SystemError, Decrypt Fail, key:" + key + "ex:", (Throwable)e);
        }
    }

    public static String decryptFromBase64(String data, Key key) {
        try {
            return new String(RSA.decrypt(Encodes.decodeBase64((String)data), key), Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new YopClientException("SystemError, Decrypt Fail, data:" + data + ", key:" + key + "ex:", (Throwable)e);
        }
    }

    static {
        SIGN_ALG_MAP.put(DigestAlgEnum.SHA256, "SHA256withRSA");
    }
}

