/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.impl;

import java.util.LinkedList;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.client.KrbContext;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.KrbSetting;
import org.apache.kerby.kerberos.kerb.client.PkinitOption;
import org.apache.kerby.kerberos.kerb.client.TokenOption;
import org.apache.kerby.kerberos.kerb.client.impl.InternalKrbClient;
import org.apache.kerby.kerberos.kerb.client.request.AsRequest;
import org.apache.kerby.kerberos.kerb.client.request.AsRequestWithCert;
import org.apache.kerby.kerberos.kerb.client.request.AsRequestWithKeytab;
import org.apache.kerby.kerberos.kerb.client.request.AsRequestWithPasswd;
import org.apache.kerby.kerberos.kerb.client.request.AsRequestWithToken;
import org.apache.kerby.kerberos.kerb.client.request.TgsRequest;
import org.apache.kerby.kerberos.kerb.client.request.TgsRequestWithTgt;
import org.apache.kerby.kerberos.kerb.client.request.TgsRequestWithToken;
import org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.kerby.kerberos.kerb.type.base.NameType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;

public abstract class AbstractInternalKrbClient
implements InternalKrbClient {
    private KrbContext context;
    private final KrbSetting krbSetting;

    public AbstractInternalKrbClient(KrbSetting krbSetting) {
        this.krbSetting = krbSetting;
    }

    protected KrbContext getContext() {
        return this.context;
    }

    @Override
    public KrbSetting getSetting() {
        return this.krbSetting;
    }

    @Override
    public void init() throws KrbException {
        this.context = new KrbContext();
        this.context.init(this.krbSetting);
    }

    @Override
    public TgtTicket requestTgt(KOptions requestOptions) throws KrbException {
        AsRequest asRequest = null;
        PrincipalName clientPrincipalName = null;
        if (requestOptions.contains((KOption)KrbOption.USE_PASSWD)) {
            asRequest = new AsRequestWithPasswd(this.context);
        } else if (requestOptions.contains((KOption)KrbOption.USE_KEYTAB)) {
            asRequest = new AsRequestWithKeytab(this.context);
        } else if (requestOptions.contains((KOption)PkinitOption.USE_ANONYMOUS)) {
            asRequest = new AsRequestWithCert(this.context);
        } else if (requestOptions.contains((KOption)PkinitOption.USE_PKINIT)) {
            asRequest = new AsRequestWithCert(this.context);
        } else if (requestOptions.contains((KOption)TokenOption.USE_TOKEN)) {
            asRequest = new AsRequestWithToken(this.context);
        } else if (requestOptions.contains((KOption)TokenOption.USER_ID_TOKEN)) {
            asRequest = new AsRequestWithToken(this.context);
        }
        if (asRequest == null) {
            throw new IllegalArgumentException("No valid krb client request option found");
        }
        if (requestOptions.contains((KOption)KrbOption.CLIENT_PRINCIPAL)) {
            String clientPrincipalString = requestOptions.getStringOption((KOption)KrbOption.CLIENT_PRINCIPAL);
            clientPrincipalString = this.fixPrincipal(clientPrincipalString);
            clientPrincipalName = new PrincipalName(clientPrincipalString);
            if (requestOptions.contains((KOption)PkinitOption.USE_ANONYMOUS)) {
                clientPrincipalName.setNameType(NameType.NT_WELLKNOWN);
            }
            asRequest.setClientPrincipal(clientPrincipalName);
        }
        if (requestOptions.contains((KOption)KrbOption.SERVER_PRINCIPAL)) {
            String serverPrincipalString = requestOptions.getStringOption((KOption)KrbOption.SERVER_PRINCIPAL);
            serverPrincipalString = this.fixPrincipal(serverPrincipalString);
            PrincipalName serverPrincipalName = new PrincipalName(serverPrincipalString, NameType.NT_PRINCIPAL);
            asRequest.setServerPrincipal(serverPrincipalName);
        } else if (clientPrincipalName != null) {
            String realm = clientPrincipalName.getRealm();
            PrincipalName serverPrincipalName = KrbUtil.makeTgsPrincipal((String)realm);
            asRequest.setServerPrincipal(serverPrincipalName);
        }
        asRequest.setRequestOptions(requestOptions);
        return this.doRequestTgt(asRequest);
    }

    @Override
    public SgtTicket requestSgt(KOptions requestOptions) throws KrbException {
        String destRealm;
        String sourceRealm;
        TgsRequest tgsRequest = null;
        TgtTicket tgtTicket = null;
        if (requestOptions.contains((KOption)TokenOption.USER_AC_TOKEN)) {
            tgsRequest = new TgsRequestWithToken(this.context);
        } else if (requestOptions.contains((KOption)KrbOption.USE_TGT)) {
            KOption kOpt = requestOptions.getOption((KOption)KrbOption.USE_TGT);
            tgtTicket = (TgtTicket)kOpt.getOptionInfo().getValue();
            tgsRequest = new TgsRequestWithTgt(this.context, tgtTicket);
        }
        if (tgsRequest == null) {
            throw new IllegalArgumentException("No valid krb client request option found");
        }
        String serverPrincipalString = this.fixPrincipal(requestOptions.getStringOption((KOption)KrbOption.SERVER_PRINCIPAL));
        PrincipalName serverPrincipalName = new PrincipalName(serverPrincipalString);
        if (tgtTicket != null && !(sourceRealm = tgtTicket.getRealm()).equals(destRealm = serverPrincipalName.getRealm())) {
            KrbConfig krbConfig = this.krbSetting.getKrbConfig();
            LinkedList<String> capath = krbConfig.getCapath(sourceRealm, destRealm);
            PrincipalName clientPrincipalName = tgtTicket.getClientPrincipal();
            for (int i = 0; i < capath.size() - 1; ++i) {
                PrincipalName tgsPrincipalName = KrbUtil.makeTgsPrincipal((String)capath.get(i), (String)capath.get(i + 1));
                tgsRequest.setServerPrincipal(tgsPrincipalName);
                tgsRequest.setRequestOptions(requestOptions);
                SgtTicket sgtTicket = this.doRequestSgt(tgsRequest);
                sgtTicket.setClientPrincipal(clientPrincipalName);
                tgsRequest = new TgsRequestWithTgt(this.context, sgtTicket);
            }
        }
        tgsRequest.setServerPrincipal(serverPrincipalName);
        tgsRequest.setRequestOptions(requestOptions);
        return this.doRequestSgt(tgsRequest);
    }

    protected abstract TgtTicket doRequestTgt(AsRequest var1) throws KrbException;

    protected abstract SgtTicket doRequestSgt(TgsRequest var1) throws KrbException;

    protected String fixPrincipal(String principal) {
        if (!principal.contains("@")) {
            principal = principal + "@" + this.krbSetting.getKdcRealm();
        }
        return principal;
    }
}

