/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public final class Zips {
    public static void zip(File dir, File zipName) throws IOException, IllegalArgumentException {
        String[] entries = dir.list();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipName));
        String prefix = dir.getAbsolutePath();
        if (!prefix.endsWith(File.separator)) {
            prefix = prefix + File.separator;
        }
        for (String entry : entries) {
            File f = new File(dir, entry);
            Zips.zip(out, f, prefix, zipName.getName().substring(0, zipName.getName().length() - 4));
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static void zip(ZipOutputStream out, File f, String prefix, String root) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File child : files) {
                    Zips.zip(out, child, prefix, root);
                }
            }
        } else {
            FileInputStream in = new FileInputStream(f);
            ZipEntry entry = new ZipEntry(root + "/" + f.getPath().replace(prefix, ""));
            out.putNextEntry(entry);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private Zips() {
    }
}

