/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.controller;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.ApiResult;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.ui.vo.WarmFlowVo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warm-flow-ui"})
public class WarmFlowUiController {
    @GetMapping(value={"/token-name"})
    public ApiResult<List<String>> tokenName() {
        String tokenName = FlowEngine.getFlowConfig().getTokenName();
        if (StringUtils.isEmpty((String)tokenName)) {
            return ApiResult.fail((String)"\u672a\u914d\u7f6etokenName");
        }
        String[] tokenNames = tokenName.split(",");
        List tokenNameList = Arrays.stream(tokenNames).filter(StringUtils::isNotEmpty).map(String::trim).collect(Collectors.toList());
        return ApiResult.ok(tokenNameList);
    }

    @GetMapping(value={"/config"})
    public ApiResult<WarmFlowVo> config() {
        WarmFlowVo warmFlowVo = new WarmFlowVo();
        String tokenName = FlowEngine.getFlowConfig().getTokenName();
        if (StringUtils.isEmpty((String)tokenName)) {
            return ApiResult.fail((String)"\u672a\u914d\u7f6etokenName");
        }
        String[] tokenNames = tokenName.split(",");
        List tokenNameList = Arrays.stream(tokenNames).filter(StringUtils::isNotEmpty).map(String::trim).collect(Collectors.toList());
        warmFlowVo.setTokenNameList(tokenNameList);
        return ApiResult.ok((Object)warmFlowVo);
    }
}

