/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.content.api.ContentItem;
import org.flowable.content.engine.impl.cmd.AbstractDeleteContentItemCmd;
import org.flowable.content.engine.impl.persistence.entity.ContentItemEntityManager;
import org.flowable.content.engine.impl.util.CommandContextUtil;

public class DeleteContentItemsCmd
extends AbstractDeleteContentItemCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String taskId;
    protected String scopeId;
    protected String scopeType;

    public DeleteContentItemsCmd(String processInstanceId, String taskId, String scopeId, String scopeType) {
        this.processInstanceId = processInstanceId;
        this.taskId = taskId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null && this.taskId == null && this.scopeId == null) {
            throw new FlowableIllegalArgumentException("taskId, processInstanceId and scopeId are null");
        }
        ContentItemEntityManager contentItemEntityManager = CommandContextUtil.getContentItemEntityManager();
        if (this.processInstanceId != null) {
            List<ContentItem> contentItems = contentItemEntityManager.findContentItemsByProcessInstanceId(this.processInstanceId);
            if (contentItems != null) {
                for (ContentItem contentItem : contentItems) {
                    this.deleteContentItemInContentStorage(contentItem);
                }
            }
            contentItemEntityManager.deleteContentItemsByProcessInstanceId(this.processInstanceId);
        } else if (StringUtils.isNotEmpty((CharSequence)this.scopeId)) {
            List<ContentItem> contentItems = contentItemEntityManager.findContentItemsByScopeIdAndScopeType(this.scopeId, this.scopeType);
            if (contentItems != null) {
                for (ContentItem contentItem : contentItems) {
                    this.deleteContentItemInContentStorage(contentItem);
                }
            }
            contentItemEntityManager.deleteContentItemsByScopeIdAndScopeType(this.scopeId, this.scopeType);
        } else {
            List<ContentItem> contentItems = contentItemEntityManager.findContentItemsByTaskId(this.taskId);
            if (contentItems != null) {
                for (ContentItem contentItem : contentItems) {
                    this.deleteContentItemInContentStorage(contentItem);
                }
            }
            contentItemEntityManager.deleteContentItemsByTaskId(this.taskId);
        }
        return null;
    }
}

