/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.db;

import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.EngineDatabaseConfiguration;
import org.flowable.common.engine.impl.db.LiquibaseBasedSchemaManager;
import org.flowable.common.engine.impl.db.LiquibaseDatabaseConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.content.engine.impl.util.CommandContextUtil;

public class ContentDbSchemaManager
extends LiquibaseBasedSchemaManager {
    public static final String LIQUIBASE_CHANGELOG = "org/flowable/content/db/liquibase/flowable-content-db-changelog.xml";

    public ContentDbSchemaManager() {
        super("content", LIQUIBASE_CHANGELOG, "ACT_CO_");
    }

    protected LiquibaseDatabaseConfiguration getDatabaseConfiguration() {
        return new EngineDatabaseConfiguration((AbstractEngineConfiguration)CommandContextUtil.getContentEngineConfiguration());
    }

    public void initSchema() {
        this.initSchema(CommandContextUtil.getContentEngineConfiguration().getDatabaseSchemaUpdate());
    }

    public void schemaCreate() {
        this.getCommonSchemaManager().schemaCreate();
        super.schemaCreate();
    }

    public void schemaDrop() {
        try {
            super.schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping content engine tables", (Throwable)e);
        }
        try {
            this.getCommonSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping common tables", (Throwable)e);
        }
    }

    public String schemaUpdate() {
        this.getCommonSchemaManager().schemaUpdate();
        return super.schemaUpdate();
    }

    protected SchemaManager getCommonSchemaManager() {
        return CommandContextUtil.getContentEngineConfiguration().getCommonSchemaManager();
    }
}

