/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.content.api.ContentItem;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.impl.ContentItemQueryImpl;
import org.flowable.content.engine.impl.persistence.entity.ContentItemEntity;
import org.flowable.content.engine.impl.persistence.entity.ContentItemEntityImpl;
import org.flowable.content.engine.impl.persistence.entity.data.AbstractContentDataManager;
import org.flowable.content.engine.impl.persistence.entity.data.ContentItemDataManager;

public class MybatisContentItemDataManager
extends AbstractContentDataManager<ContentItemEntity>
implements ContentItemDataManager {
    protected CachedEntityMatcher<ContentItemEntity> contentItemsByTaskId = (databaseEntities, cachedEntities, entity, param) -> {
        String taskId = (String)param;
        return Objects.equals(entity.getTaskId(), taskId);
    };
    protected CachedEntityMatcher<ContentItemEntity> contentItemsByProcessInstanceId = (databaseEntities, cachedEntities, entity, param) -> {
        String processInstanceId = (String)param;
        return Objects.equals(entity.getProcessInstanceId(), processInstanceId);
    };
    protected CachedEntityMatcher<ContentItemEntity> contentItemsByScopeIdAndScopeType = (databaseEntities, cachedEntities, entity, param) -> {
        Map params = (Map)param;
        String scopeId = params.get("scopeId").toString();
        String scopeType = params.get("scopeType").toString();
        return Objects.equals(entity.getScopeId(), scopeId) && Objects.equals(entity.getScopeType(), scopeType);
    };

    public MybatisContentItemDataManager(ContentEngineConfiguration contentEngineConfiguration) {
        super(contentEngineConfiguration);
    }

    public Class<? extends ContentItemEntity> getManagedEntityClass() {
        return ContentItemEntityImpl.class;
    }

    public ContentItemEntity create() {
        return new ContentItemEntityImpl();
    }

    @Override
    public long findContentItemCountByQueryCriteria(ContentItemQueryImpl contentItemQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectContentItemCountByQueryCriteria", (Object)contentItemQuery);
    }

    @Override
    public List<ContentItem> findContentItemsByQueryCriteria(ContentItemQueryImpl contentItemQuery) {
        return this.getDbSqlSession().selectList("selectContentItemsByQueryCriteria", (ListQueryParameterObject)contentItemQuery, this.getManagedEntityClass());
    }

    @Override
    public List<ContentItem> findContentItemsByTaskId(String taskId) {
        return this.getList("selectContentItemsByTaskId", taskId, this.contentItemsByTaskId, true);
    }

    @Override
    public void deleteContentItemsByTaskId(String taskId) {
        this.getDbSqlSession().delete("deleteContentItemsByTaskId", (Object)taskId, this.getManagedEntityClass());
    }

    @Override
    public List<ContentItem> findContentItemsByProcessInstanceId(String processInstanceId) {
        return this.getList("selectContentItemsByProcessInstanceId", processInstanceId, this.contentItemsByProcessInstanceId, true);
    }

    @Override
    public void deleteContentItemsByProcessInstanceId(String processInstanceId) {
        this.getDbSqlSession().delete("deleteContentItemsByProcessInstanceId", (Object)processInstanceId, this.getManagedEntityClass());
    }

    @Override
    public List<ContentItem> findContentItemsByScopeIdAndScopeType(String scopeId, String scopeType) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("scopeId", scopeId);
        params.put("scopeType", scopeType);
        return this.getList("selectContentItemsByScopeIdAndScopeType", params, this.contentItemsByScopeIdAndScopeType, true);
    }

    @Override
    public void deleteContentItemsByScopeIdAndScopeType(String scopeId, String scopeType) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("scopeId", scopeId);
        params.put("scopeType", scopeType);
        this.getDbSqlSession().delete("deleteContentItemsByScopeIdAndScopeType", params, this.getManagedEntityClass());
    }
}

