/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import org.htmlunit.WebClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcAutoConfiguration;
import org.springframework.boot.test.web.htmlunit.LocalHostWebClient;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebClientBuilder;

@AutoConfiguration(after={MockMvcAutoConfiguration.class})
@ConditionalOnClass(value={WebClient.class})
@ConditionalOnBooleanProperty(name={"spring.test.mockmvc.webclient.enabled"}, matchIfMissing=true)
public class MockMvcWebClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WebClient.class, MockMvcWebClientBuilder.class})
    @ConditionalOnBean(value={MockMvc.class})
    public MockMvcWebClientBuilder mockMvcWebClientBuilder(MockMvc mockMvc, Environment environment) {
        return MockMvcWebClientBuilder.mockMvcSetup((MockMvc)mockMvc).withDelegate((WebClient)new LocalHostWebClient(environment));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MockMvcWebClientBuilder.class})
    public WebClient htmlUnitWebClient(MockMvcWebClientBuilder builder) {
        return builder.build();
    }
}

