/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.UnaryOperator;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.spi.NumberSystem;

public class DefaultNumberSystem
implements NumberSystem {
    @Override
    public Number add(Number x, Number y) {
        NumberType type_x = NumberType.valueOf(x);
        NumberType type_y = NumberType.valueOf(y);
        boolean reorder_args = type_y.ordinal() > type_x.ordinal();
        return reorder_args ? (Number)this.addWideAndNarrow(type_y, y, type_x, x) : (Number)this.addWideAndNarrow(type_x, x, type_y, y);
    }

    @Override
    public Number subtract(Number x, Number y) {
        return this.add(x, this.negate(y));
    }

    @Override
    public Number multiply(Number x, Number y) {
        NumberType type_x = NumberType.valueOf(x);
        NumberType type_y = NumberType.valueOf(y);
        boolean reorder_args = type_y.ordinal() > type_x.ordinal();
        return reorder_args ? (Number)this.multiplyWideAndNarrow(type_y, y, type_x, x) : (Number)this.multiplyWideAndNarrow(type_x, x, type_y, y);
    }

    @Override
    public Number divide(Number x, Number y) {
        return this.multiply(x, this.reciprocal(y));
    }

    @Override
    public Number[] divideAndRemainder(Number x, Number y, boolean roundRemainderTowardsZero) {
        boolean yieldIntegerResult;
        int sign_y;
        int sign_x = this.signum(x);
        int sign = sign_x * (sign_y = this.signum(y));
        if (sign == 0) {
            if (sign_y == 0) {
                throw new ArithmeticException("division by zero");
            }
            if (sign_x == 0) {
                return new Number[]{0, 0};
            }
        }
        Number absX = this.abs(x);
        Number absY = this.abs(y);
        NumberType type_x = NumberType.valueOf(absX);
        NumberType type_y = NumberType.valueOf(absY);
        boolean bl = yieldIntegerResult = type_x.isIntegerOnly() && type_y.isIntegerOnly();
        if (yieldIntegerResult) {
            BigInteger integer_x = this.integerToBigInteger(absX);
            BigInteger integer_y = this.integerToBigInteger(absY);
            Number[] divAndRemainder = integer_x.divideAndRemainder(integer_y);
            return DefaultNumberSystem.applyToArray(divAndRemainder, number -> DefaultNumberSystem.copySignTo(sign, (BigInteger)number));
        }
        MathContext mathContext = new MathContext(Calculus.MATH_CONTEXT.getPrecision(), RoundingMode.FLOOR);
        BigDecimal decimal_x = type_x == NumberType.RATIONAL ? ((RationalNumber)absX).bigDecimalValue() : this.toBigDecimal(absX);
        BigDecimal decimal_y = type_y == NumberType.RATIONAL ? ((RationalNumber)absY).bigDecimalValue() : this.toBigDecimal(absY);
        Number[] divAndRemainder = decimal_x.divideAndRemainder(decimal_y, mathContext);
        if (roundRemainderTowardsZero) {
            return new Number[]{DefaultNumberSystem.copySignTo(sign, (BigDecimal)divAndRemainder[0]), DefaultNumberSystem.copySignTo(sign, ((BigDecimal)divAndRemainder[1]).toBigInteger())};
        }
        return DefaultNumberSystem.applyToArray(divAndRemainder, number -> DefaultNumberSystem.copySignTo(sign, (BigDecimal)number));
    }

    @Override
    public Number reciprocal(Number number) {
        if (this.isIntegerOnly(number)) {
            return RationalNumber.of(BigInteger.ONE, this.integerToBigInteger(number));
        }
        if (number instanceof BigDecimal) {
            return RationalNumber.of((BigDecimal)number).reciprocal();
        }
        if (number instanceof RationalNumber) {
            return ((RationalNumber)number).reciprocal();
        }
        if (number instanceof Double) {
            return RationalNumber.of((Double)number).reciprocal();
        }
        if (number instanceof Float) {
            return RationalNumber.of(number.doubleValue()).reciprocal();
        }
        throw this.unsupportedNumberType(number);
    }

    @Override
    public int signum(Number number) {
        if (number instanceof BigInteger) {
            return ((BigInteger)number).signum();
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).signum();
        }
        if (number instanceof RationalNumber) {
            return ((RationalNumber)number).signum();
        }
        if (number instanceof Double) {
            return (int)Math.signum((Double)number);
        }
        if (number instanceof Float) {
            return (int)Math.signum(((Float)number).floatValue());
        }
        if (number instanceof Long || number instanceof AtomicLong) {
            long longValue = number.longValue();
            return Long.signum(longValue);
        }
        if (number instanceof Integer || number instanceof AtomicInteger || number instanceof Short || number instanceof Byte) {
            int intValue = number.intValue();
            return Integer.signum(intValue);
        }
        throw this.unsupportedNumberType(number);
    }

    @Override
    public Number abs(Number number) {
        if (number instanceof BigInteger) {
            return ((BigInteger)number).abs();
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).abs();
        }
        if (number instanceof RationalNumber) {
            return ((RationalNumber)number).abs();
        }
        if (number instanceof Double) {
            return Math.abs((Double)number);
        }
        if (number instanceof Float) {
            return Float.valueOf(Math.abs(((Float)number).floatValue()));
        }
        if (number instanceof Long || number instanceof AtomicLong) {
            long longValue = number.longValue();
            if (longValue == Long.MIN_VALUE) {
                return BigInteger.valueOf(longValue).abs();
            }
            return Math.abs(longValue);
        }
        if (number instanceof Integer || number instanceof AtomicInteger) {
            int intValue = number.intValue();
            if (intValue == Integer.MIN_VALUE) {
                return Math.abs(number.longValue());
            }
            return Math.abs(intValue);
        }
        if (number instanceof Short || number instanceof Byte) {
            Math.abs(number.intValue());
        }
        throw this.unsupportedNumberType(number);
    }

    @Override
    public Number negate(Number number) {
        if (number instanceof BigInteger) {
            return ((BigInteger)number).negate();
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).negate();
        }
        if (number instanceof RationalNumber) {
            return ((RationalNumber)number).negate();
        }
        if (number instanceof Double) {
            return -((Double)number).doubleValue();
        }
        if (number instanceof Float) {
            return Float.valueOf(-((Float)number).floatValue());
        }
        if (number instanceof Long || number instanceof AtomicLong) {
            long longValue = number.longValue();
            if (longValue == Long.MIN_VALUE) {
                return BigInteger.valueOf(longValue).negate();
            }
            return -longValue;
        }
        if (number instanceof Integer || number instanceof AtomicInteger) {
            int intValue = number.intValue();
            if (intValue == Integer.MIN_VALUE) {
                return -number.longValue();
            }
            return -intValue;
        }
        if (number instanceof Short) {
            short shortValue = (Short)number;
            if (shortValue == Short.MIN_VALUE) {
                return -number.intValue();
            }
            return (int)(-shortValue);
        }
        if (number instanceof Byte) {
            short byteValue = ((Byte)number).byteValue();
            if (byteValue == -128) {
                return -number.intValue();
            }
            return (int)(-byteValue);
        }
        throw this.unsupportedNumberType(number);
    }

    @Override
    public Number power(Number number, int exponent) {
        if (exponent == 0) {
            if (this.isZero(number)) {
                throw new ArithmeticException("0^0 is not defined");
            }
            return 1;
        }
        if (number instanceof BigInteger || number instanceof Long || number instanceof AtomicLong || number instanceof Integer || number instanceof AtomicInteger || number instanceof Short || number instanceof Byte) {
            BigInteger bigInt = this.integerToBigInteger(number);
            if (exponent > 0) {
                return bigInt.pow(exponent);
            }
            return RationalNumber.ofInteger(bigInt).pow(exponent);
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).pow(exponent, Calculus.MATH_CONTEXT);
        }
        if (number instanceof RationalNumber) {
            ((RationalNumber)number).pow(exponent);
        }
        if (number instanceof Double || number instanceof Float) {
            return this.toBigDecimal(number).pow(exponent, Calculus.MATH_CONTEXT);
        }
        throw this.unsupportedNumberType(number);
    }

    @Override
    public Number exp(Number number) {
        return Math.exp(number.doubleValue());
    }

    @Override
    public Number log(Number number) {
        return Math.log(number.doubleValue());
    }

    @Override
    public Number narrow(Number number) {
        if (number instanceof Integer || number instanceof AtomicInteger || number instanceof Short || number instanceof Byte) {
            return number;
        }
        if (number instanceof Double || number instanceof Float) {
            double doubleValue = number.doubleValue();
            if (doubleValue % 1.0 == 0.0) {
                return this.narrow(BigDecimal.valueOf(doubleValue));
            }
            return number;
        }
        if (this.isIntegerOnly(number)) {
            int total_bits_required = this.bitLengthOfInteger(number);
            if (total_bits_required < 31) {
                return number.intValue();
            }
            if (total_bits_required < 63) {
                return number.longValue();
            }
            return number;
        }
        if (number instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)number;
            try {
                BigInteger integer = decimal.toBigIntegerExact();
                return this.narrow(integer);
            }
            catch (ArithmeticException e) {
                return number;
            }
        }
        if (number instanceof RationalNumber) {
            RationalNumber rational = (RationalNumber)number;
            return rational.isInteger() ? (Number)this.narrow(rational.getDividend()) : (Number)number;
        }
        return number;
    }

    @Override
    public int compare(Number x, Number y) {
        NumberType type_x = NumberType.valueOf(x);
        NumberType type_y = NumberType.valueOf(y);
        boolean reorder_args = type_y.ordinal() > type_x.ordinal();
        return reorder_args ? -this.compareWideVsNarrow(type_y, y, type_x, x) : this.compareWideVsNarrow(type_x, x, type_y, y);
    }

    @Override
    public boolean isZero(Number number) {
        NumberType numberType = NumberType.valueOf(number);
        return this.compare(numberType.zero, number) == 0;
    }

    @Override
    public boolean isOne(Number number) {
        NumberType numberType = NumberType.valueOf(number);
        return this.compare(numberType.one, number) == 0;
    }

    @Override
    public boolean isLessThanOne(Number number) {
        NumberType numberType = NumberType.valueOf(number);
        return this.compare(numberType.one, number) < 0;
    }

    @Override
    public boolean isInteger(Number number) {
        NumberType numberType = NumberType.valueOf(number);
        return this.isInteger(numberType, number);
    }

    private IllegalArgumentException unsupportedNumberType(Number number) {
        String msg = String.format("Unsupported number type '%s' in number system '%s'", number.getClass().getName(), this.getClass().getName());
        return new IllegalArgumentException(msg);
    }

    private IllegalStateException unexpectedCodeReach() {
        String msg = String.format("Implementation Error: Code was reached that is expected unreachable", new Object[0]);
        return new IllegalStateException(msg);
    }

    private boolean isIntegerOnly(Number number) {
        return NumberType.valueOf(number).isIntegerOnly();
    }

    private boolean isInteger(NumberType numberType, Number number) {
        if (numberType.isIntegerOnly()) {
            return true;
        }
        if (number instanceof RationalNumber) {
            return ((RationalNumber)number).isInteger();
        }
        if (number instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)number;
            if (decimal.scale() <= 0) {
                return true;
            }
            try {
                decimal.toBigIntegerExact();
                return true;
            }
            catch (ArithmeticException ex) {
                return false;
            }
        }
        if (number instanceof Double || number instanceof Float) {
            double doubleValue = number.doubleValue();
            return doubleValue % 1.0 == 0.0;
        }
        throw this.unsupportedNumberType(number);
    }

    private int bitLengthOfInteger(Number number) {
        if (number instanceof BigInteger) {
            return ((BigInteger)number).bitLength();
        }
        long long_value = number.longValue();
        if (long_value == Long.MIN_VALUE) {
            return 63;
        }
        int leadingZeros = Long.numberOfLeadingZeros(Math.abs(long_value));
        return 64 - leadingZeros;
    }

    private BigInteger integerToBigInteger(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    private BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Long || number instanceof AtomicLong || number instanceof Integer || number instanceof AtomicInteger || number instanceof Short || number instanceof Byte) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (number instanceof RationalNumber) {
            throw this.unexpectedCodeReach();
        }
        throw this.unsupportedNumberType(number);
    }

    private Number addWideAndNarrow(NumberType wideType, Number wide, NumberType narrowType, Number narrow) {
        if (wideType.isIntegerOnly()) {
            if (wide instanceof BigInteger) {
                return ((BigInteger)wide).add(this.integerToBigInteger(narrow));
            }
            int total_bits_required = Math.max(this.bitLengthOfInteger(wide), this.bitLengthOfInteger(narrow)) + 1;
            if (total_bits_required < 63) {
                return wide.longValue() + narrow.longValue();
            }
            return this.integerToBigInteger(wide).add(this.integerToBigInteger(narrow));
        }
        if (wide instanceof RationalNumber) {
            if (narrow instanceof RationalNumber) {
                return ((RationalNumber)wide).add((RationalNumber)narrow);
            }
            return ((RationalNumber)wide).add(RationalNumber.ofInteger(this.integerToBigInteger(narrow)));
        }
        if (wide instanceof BigDecimal) {
            if (narrow instanceof BigDecimal) {
                return ((BigDecimal)wide).add((BigDecimal)narrow, Calculus.MATH_CONTEXT);
            }
            if (narrow instanceof Double || narrow instanceof Float) {
                return ((BigDecimal)wide).add(BigDecimal.valueOf(narrow.doubleValue()), Calculus.MATH_CONTEXT);
            }
            if (narrow instanceof RationalNumber) {
                return ((BigDecimal)wide).add(((RationalNumber)narrow).bigDecimalValue());
            }
            return ((BigDecimal)wide).add(BigDecimal.valueOf(narrow.longValue()));
        }
        if (narrow instanceof Double || narrow instanceof Float) {
            return BigDecimal.valueOf(wide.doubleValue()).add(BigDecimal.valueOf(narrow.doubleValue()));
        }
        if (narrow instanceof RationalNumber) {
            return BigDecimal.valueOf(wide.doubleValue()).add(((RationalNumber)narrow).bigDecimalValue());
        }
        if (narrow instanceof BigInteger) {
            return BigDecimal.valueOf(wide.doubleValue()).add(new BigDecimal((BigInteger)narrow));
        }
        return BigDecimal.valueOf(wide.doubleValue()).add(BigDecimal.valueOf(narrow.longValue()));
    }

    private Number multiplyWideAndNarrow(NumberType wideType, Number wide, NumberType narrowType, Number narrow) {
        if (wideType.isIntegerOnly()) {
            if (wide instanceof BigInteger) {
                return ((BigInteger)wide).multiply(this.integerToBigInteger(narrow));
            }
            int total_bits_required = this.bitLengthOfInteger(wide) + this.bitLengthOfInteger(narrow);
            if (total_bits_required < 63) {
                return wide.longValue() * narrow.longValue();
            }
            return this.integerToBigInteger(wide).multiply(this.integerToBigInteger(narrow));
        }
        if (wide instanceof RationalNumber) {
            if (narrow instanceof RationalNumber) {
                return ((RationalNumber)wide).multiply((RationalNumber)narrow);
            }
            return ((RationalNumber)wide).multiply(RationalNumber.ofInteger(this.integerToBigInteger(narrow)));
        }
        if (wide instanceof BigDecimal) {
            if (narrow instanceof BigDecimal) {
                return ((BigDecimal)wide).multiply((BigDecimal)narrow, Calculus.MATH_CONTEXT);
            }
            if (narrow instanceof Double || narrow instanceof Float) {
                return ((BigDecimal)wide).multiply(BigDecimal.valueOf(narrow.doubleValue()), Calculus.MATH_CONTEXT);
            }
            if (narrow instanceof RationalNumber) {
                return ((BigDecimal)wide).multiply(((RationalNumber)narrow).bigDecimalValue());
            }
            return ((BigDecimal)wide).multiply(BigDecimal.valueOf(narrow.longValue()));
        }
        if (narrow instanceof Double || narrow instanceof Float) {
            return wide.doubleValue() * narrow.doubleValue();
        }
        if (narrow instanceof RationalNumber) {
            return BigDecimal.valueOf(wide.doubleValue()).multiply(((RationalNumber)narrow).bigDecimalValue());
        }
        if (narrow instanceof BigInteger) {
            return BigDecimal.valueOf(wide.doubleValue()).multiply(new BigDecimal((BigInteger)narrow));
        }
        return BigDecimal.valueOf(wide.doubleValue()).multiply(BigDecimal.valueOf(narrow.longValue()));
    }

    private int compareWideVsNarrow(NumberType wideType, Number wide, NumberType narrowType, Number narrow) {
        if (wideType.isIntegerOnly()) {
            if (wide instanceof BigInteger) {
                return ((BigInteger)wide).compareTo(this.integerToBigInteger(narrow));
            }
            return Long.compare(wide.longValue(), narrow.longValue());
        }
        if (wide instanceof RationalNumber) {
            if (narrow instanceof RationalNumber) {
                return ((RationalNumber)wide).compareTo((RationalNumber)narrow);
            }
            return ((RationalNumber)wide).compareTo(RationalNumber.ofInteger(this.integerToBigInteger(narrow)));
        }
        if (wide instanceof BigDecimal) {
            if (narrow instanceof BigDecimal) {
                return ((BigDecimal)wide).compareTo((BigDecimal)narrow);
            }
            if (narrow instanceof Double || narrow instanceof Float) {
                return ((BigDecimal)wide).compareTo(BigDecimal.valueOf(narrow.doubleValue()));
            }
            if (narrow instanceof RationalNumber) {
                return ((BigDecimal)wide).compareTo(((RationalNumber)narrow).bigDecimalValue());
            }
            return ((BigDecimal)wide).compareTo(BigDecimal.valueOf(narrow.longValue()));
        }
        if (narrow instanceof Double || narrow instanceof Float) {
            return Double.compare(wide.doubleValue(), narrow.doubleValue());
        }
        if (narrow instanceof RationalNumber) {
            return BigDecimal.valueOf(wide.doubleValue()).compareTo(((RationalNumber)narrow).bigDecimalValue());
        }
        if (narrow instanceof BigInteger) {
            return BigDecimal.valueOf(wide.doubleValue()).compareTo(new BigDecimal((BigInteger)narrow));
        }
        return BigDecimal.valueOf(wide.doubleValue()).compareTo(BigDecimal.valueOf(narrow.longValue()));
    }

    private static BigInteger copySignTo(int sign, BigInteger absNumber) {
        if (sign == -1) {
            return absNumber.negate();
        }
        return absNumber;
    }

    private static BigDecimal copySignTo(int sign, BigDecimal absNumber) {
        if (sign == -1) {
            return absNumber.negate();
        }
        return absNumber;
    }

    private static Number[] applyToArray(Number[] array, UnaryOperator<Number> operator) {
        return new Number[]{(Number)operator.apply(array[0]), (Number)operator.apply(array[1])};
    }

    private static enum NumberType {
        BYTE_BOXED(true, Byte.class, (byte)1, (byte)0),
        SHORT_BOXED(true, Short.class, (short)1, (short)0),
        INTEGER_BOXED(true, Integer.class, 1, 0),
        INTEGER_ATOMIC(true, AtomicInteger.class, 1, 0),
        LONG_BOXED(true, Long.class, 1L, 0L),
        LONG_ATOMIC(true, AtomicLong.class, 1L, 0),
        BIG_INTEGER(true, BigInteger.class, BigInteger.ONE, BigInteger.ZERO),
        RATIONAL(false, RationalNumber.class, RationalNumber.ONE, RationalNumber.ZERO),
        FLOAT_BOXED(false, Float.class, Float.valueOf(1.0f), Float.valueOf(0.0f)),
        DOUBLE_BOXED(false, Double.class, 1.0, 0.0),
        BIG_DECIMAL(false, BigDecimal.class, BigDecimal.ONE, BigDecimal.ZERO);

        private final boolean integerOnly;
        private final Class<? extends Number> type;
        private final Number one;
        private final Number zero;

        private NumberType(boolean integerOnly, Class<? extends Number> type, Number one, Number zero) {
            this.integerOnly = integerOnly;
            this.type = type;
            this.one = one;
            this.zero = zero;
        }

        public boolean isIntegerOnly() {
            return this.integerOnly;
        }

        public Class<? extends Number> getType() {
            return this.type;
        }

        static NumberType valueOf(Number number) {
            if (number instanceof Long) {
                return LONG_BOXED;
            }
            if (number instanceof AtomicLong) {
                return LONG_ATOMIC;
            }
            if (number instanceof Integer) {
                return INTEGER_BOXED;
            }
            if (number instanceof AtomicInteger) {
                return INTEGER_ATOMIC;
            }
            if (number instanceof Double) {
                return DOUBLE_BOXED;
            }
            if (number instanceof Short) {
                return SHORT_BOXED;
            }
            if (number instanceof Byte) {
                return BYTE_BOXED;
            }
            if (number instanceof Float) {
                return FLOAT_BOXED;
            }
            if (number instanceof BigDecimal) {
                return BIG_DECIMAL;
            }
            if (number instanceof BigInteger) {
                return BIG_INTEGER;
            }
            if (number instanceof RationalNumber) {
                return RATIONAL;
            }
            String msg = String.format("Unsupported number type '%s'", number.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
    }
}

