/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses;

import com.azure.ai.openai.implementation.OpenAIUtils;
import com.azure.ai.openai.responses.ResponsesClientBuilder;
import com.azure.ai.openai.responses.implementation.NonAzureResponsesClientImpl;
import com.azure.ai.openai.responses.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.responses.implementation.ResponsesClientImpl;
import com.azure.ai.openai.responses.implementation.accesshelpers.CreateResponsesRequestAccessHelper;
import com.azure.ai.openai.responses.models.CreateResponseRequestAccept;
import com.azure.ai.openai.responses.models.CreateResponsesRequest;
import com.azure.ai.openai.responses.models.CreateResponsesRequestIncludable;
import com.azure.ai.openai.responses.models.DeleteResponseResponse;
import com.azure.ai.openai.responses.models.ListInputItemsRequestOrder;
import com.azure.ai.openai.responses.models.ResponsesInputItemList;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesResponse;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ResponsesClientBuilder.class, isAsync=true)
public final class ResponsesAsyncClient {
    private final ResponsesClientImpl serviceClient;
    private final NonAzureResponsesClientImpl nonAzureServiceClient;

    ResponsesAsyncClient(ResponsesClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.nonAzureServiceClient = null;
    }

    ResponsesAsyncClient(NonAzureResponsesClientImpl serviceClient) {
        this.serviceClient = null;
        this.nonAzureServiceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> createResponseWithResponse(String accept, BinaryData requestBody, RequestOptions requestOptions) {
        if (this.nonAzureServiceClient != null) {
            return this.nonAzureServiceClient.createResponseWithResponseAsync(accept, requestBody, requestOptions);
        }
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createResponseWithResponseAsync(accept, requestBody, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> getResponseWithResponse(String responseId, RequestOptions requestOptions) {
        if (this.nonAzureServiceClient != null) {
            return this.nonAzureServiceClient.getResponseWithResponseAsync(responseId, requestOptions);
        }
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getResponseWithResponseAsync(responseId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> listInputItemsWithResponse(String responseId, RequestOptions requestOptions) {
        if (this.nonAzureServiceClient != null) {
            return this.nonAzureServiceClient.listInputItemsWithResponseAsync(responseId, requestOptions);
        }
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listInputItemsWithResponseAsync(responseId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponsesResponse> getResponse(String responseId, List<CreateResponsesRequestIncludable> includables) {
        RequestOptions requestOptions = new RequestOptions();
        if (includables != null) {
            for (CreateResponsesRequestIncludable paramItemValue : includables) {
                if (paramItemValue == null) continue;
                requestOptions.addQueryParam("include[]", paramItemValue.toString(), false);
            }
        }
        return this.getResponseWithResponse(responseId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ResponsesResponse)protocolMethodData.toObject(ResponsesResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponsesResponse> getResponse(String responseId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getResponseWithResponse(responseId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ResponsesResponse)protocolMethodData.toObject(ResponsesResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResponsesResponse> createResponse(CreateResponseRequestAccept accept, CreateResponsesRequest requestBody) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createResponseWithResponse(accept.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ResponsesResponse)protocolMethodData.toObject(ResponsesResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponsesResponse> createResponse(CreateResponsesRequest requestBody) {
        RequestOptions requestOptions = new RequestOptions();
        CreateResponsesRequestAccessHelper.setStream(requestBody, false);
        return this.createResponseWithResponse(CreateResponseRequestAccept.APPLICATION_JSON.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ResponsesResponse)protocolMethodData.toObject(ResponsesResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponsesResponse> createResponse(CreateResponsesRequest requestBody, RequestOptions requestOptions) {
        CreateResponsesRequestAccessHelper.setStream(requestBody, false);
        return this.createResponseWithResponse(CreateResponseRequestAccept.APPLICATION_JSON.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ResponsesResponse)protocolMethodData.toObject(ResponsesResponse.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ResponsesStreamEvent> createResponseStream(CreateResponsesRequest requestBody) {
        RequestOptions requestOptions = new RequestOptions();
        CreateResponsesRequestAccessHelper.setStream(requestBody, true);
        Flux response = this.createResponseWithResponse(CreateResponseRequestAccept.TEXT_EVENT_STREAM.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).flatMapMany(it -> ((BinaryData)it.getValue()).toFluxByteBuffer());
        return new OpenAIServerSentEvents((Flux<ByteBuffer>)response).getEvents();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ResponsesStreamEvent> createResponseStream(CreateResponsesRequest requestBody, RequestOptions requestOptions) {
        CreateResponsesRequestAccessHelper.setStream(requestBody, true);
        Flux response = this.createResponseWithResponse(CreateResponseRequestAccept.TEXT_EVENT_STREAM.toString(), BinaryData.fromObject((Object)requestBody), requestOptions).flatMapMany(it -> ((BinaryData)it.getValue()).toFluxByteBuffer());
        return new OpenAIServerSentEvents((Flux<ByteBuffer>)response).getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> deleteResponseWithResponse(String responseId, RequestOptions requestOptions) {
        if (this.nonAzureServiceClient != null) {
            return this.nonAzureServiceClient.deleteResponseWithResponseAsync(responseId, requestOptions);
        }
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteResponseWithResponseAsync(responseId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeleteResponseResponse> deleteResponse(String responseId, RequestOptions requestOptions) {
        return this.deleteResponseWithResponse(responseId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DeleteResponseResponse)protocolMethodData.toObject(DeleteResponseResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeleteResponseResponse> deleteResponse(String responseId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteResponseWithResponse(responseId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DeleteResponseResponse)protocolMethodData.toObject(DeleteResponseResponse.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ResponsesItem> listInputItems(String responseId, Integer limit, ListInputItemsRequestOrder order) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        return new PagedFlux(() -> {
            Mono<Response<BinaryData>> responseMono = this.listInputItemsWithResponse(responseId, requestOptions);
            return responseMono.map(response -> {
                ResponsesInputItemList pagedItems = (ResponsesInputItemList)((BinaryData)response.getValue()).toObject(ResponsesInputItemList.class);
                return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), pagedItems.getData(), pagedItems.isHasMore() ? pagedItems.getLastId() : null, (Object)response.getHeaders());
            });
        }, nextLink -> {
            RequestOptions nextPageRequestOptions = new RequestOptions();
            if (limit != null) {
                nextPageRequestOptions.addQueryParam("limit", String.valueOf(limit), false);
            }
            if (order != null) {
                nextPageRequestOptions.addQueryParam("order", order.toString(), false);
            }
            nextPageRequestOptions.addQueryParam("after", nextLink, false);
            Mono<Response<BinaryData>> responseMono = this.listInputItemsWithResponse(responseId, nextPageRequestOptions);
            return responseMono.map(response -> {
                ResponsesInputItemList pagedItems = (ResponsesInputItemList)((BinaryData)response.getValue()).toObject(ResponsesInputItemList.class);
                return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), pagedItems.getData(), pagedItems.isHasMore() ? pagedItems.getLastId() : null, (Object)response.getHeaders());
            });
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResponsesInputItemList> listInputItems(String responseId, Integer limit, ListInputItemsRequestOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.listInputItemsWithResponse(responseId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ResponsesInputItemList)protocolMethodData.toObject(ResponsesInputItemList.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResponsesInputItemList> listInputItems(String responseId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.listInputItemsWithResponse(responseId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ResponsesInputItemList)protocolMethodData.toObject(ResponsesInputItemList.class));
    }
}

