/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class NonAzureResponsesClientImpl {
    private final NonAzureResponsesClientService service;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    public static final String OPEN_AI_ENDPOINT = "https://api.openai.com/v1";

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public NonAzureResponsesClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.service = (NonAzureResponsesClientService)RestProxy.create(NonAzureResponsesClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createResponseWithResponseAsync(String accept, BinaryData requestBody, RequestOptions requestOptions) {
        String contentType = "application/json";
        return FluxUtil.withContext(context -> this.service.createResponse(OPEN_AI_ENDPOINT, accept, "application/json", requestBody, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createResponseWithResponse(String accept, BinaryData requestBody, RequestOptions requestOptions) {
        String contentType = "application/json";
        return this.service.createResponseSync(OPEN_AI_ENDPOINT, accept, "application/json", requestBody, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getResponseWithResponseAsync(String responseId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResponse(OPEN_AI_ENDPOINT, responseId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getResponseWithResponse(String responseId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getResponseSync(OPEN_AI_ENDPOINT, responseId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteResponseWithResponseAsync(String responseId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteResponse(OPEN_AI_ENDPOINT, responseId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteResponseWithResponse(String responseId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteResponseSync(OPEN_AI_ENDPOINT, responseId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listInputItemsWithResponseAsync(String responseId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listInputItems(OPEN_AI_ENDPOINT, responseId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listInputItemsWithResponse(String responseId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.listInputItemsSync(OPEN_AI_ENDPOINT, responseId, "application/json", requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="NonAzureResponsesCli")
    public static interface NonAzureResponsesClientService {
        @Post(value="/responses")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createResponse(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @HeaderParam(value="Content-Type") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/responses")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createResponseSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @HeaderParam(value="Content-Type") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Get(value="/responses/{response_id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getResponse(@HostParam(value="endpoint") String var1, @PathParam(value="response_id") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/responses/{response_id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getResponseSync(@HostParam(value="endpoint") String var1, @PathParam(value="response_id") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/responses/{response_id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> deleteResponse(@HostParam(value="endpoint") String var1, @PathParam(value="response_id") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/responses/{response_id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteResponseSync(@HostParam(value="endpoint") String var1, @PathParam(value="response_id") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/responses/{response_id}/input_items")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listInputItems(@HostParam(value="endpoint") String var1, @PathParam(value="response_id") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/responses/{response_id}/input_items")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listInputItemsSync(@HostParam(value="endpoint") String var1, @PathParam(value="response_id") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

