/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesTool;
import com.azure.ai.openai.responses.models.ResponsesToolType;
import com.azure.ai.openai.responses.models.ResponsesWebSearchContextSize;
import com.azure.ai.openai.responses.models.ResponsesWebSearchLocation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesWebSearchTool
extends ResponsesTool {
    private ResponsesToolType type = ResponsesToolType.WEB_SEARCH;
    private ResponsesWebSearchLocation userLocation;
    private ResponsesWebSearchContextSize searchContextSize;

    @Override
    public ResponsesToolType getType() {
        return this.type;
    }

    public ResponsesWebSearchLocation getUserLocation() {
        return this.userLocation;
    }

    public ResponsesWebSearchTool setUserLocation(ResponsesWebSearchLocation userLocation) {
        this.userLocation = userLocation;
        return this;
    }

    public ResponsesWebSearchContextSize getSearchContextSize() {
        return this.searchContextSize;
    }

    public ResponsesWebSearchTool setSearchContextSize(ResponsesWebSearchContextSize searchContextSize) {
        this.searchContextSize = searchContextSize;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("user_location", (JsonSerializable)this.userLocation);
        jsonWriter.writeStringField("search_context_size", this.searchContextSize == null ? null : this.searchContextSize.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesWebSearchTool fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesWebSearchTool)jsonReader.readObject(reader -> {
            ResponsesWebSearchTool deserializedResponsesWebSearchTool = new ResponsesWebSearchTool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesWebSearchTool.type = ResponsesToolType.fromString(reader.getString());
                    continue;
                }
                if ("user_location".equals(fieldName)) {
                    deserializedResponsesWebSearchTool.userLocation = ResponsesWebSearchLocation.fromJson(reader);
                    continue;
                }
                if ("search_context_size".equals(fieldName)) {
                    deserializedResponsesWebSearchTool.searchContextSize = ResponsesWebSearchContextSize.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponsesWebSearchTool;
        });
    }
}

