/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import com.xxl.tool.core.AssertTool;
import com.xxl.tool.io.IOTool;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class FileTool {
    private static final OpenOption[] OPEN_OPTIONS_APPEND = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static File getParentFile(File file) {
        return file == null ? null : file.getParentFile();
    }

    public static void mkdirs(File directory) throws IOException {
        if (directory != null && !directory.mkdirs() && !directory.isDirectory()) {
            throw new IOException("Cannot create directory '" + directory + "'.");
        }
    }

    public static void createParentDirectories(File file) throws IOException {
        FileTool.mkdirs(FileTool.getParentFile(file));
    }

    public static void copyFile(String srcFilePath, String destFilePath, CopyOption ... copyOptions) throws IOException {
        AssertTool.notNull(srcFilePath, "No srcFile File specified");
        AssertTool.notNull(destFilePath, "No destFile File specified");
        File srcFile = new File(srcFilePath);
        File destFile = new File(destFilePath);
        if (!srcFile.exists() || !srcFile.isFile()) {
            throw new IOException("File '" + srcFile + "' does not exist or is not a file");
        }
        FileTool.createParentDirectories(destFile);
        if (copyOptions == null || copyOptions.length == 0) {
            copyOptions = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
        }
        Files.copy(srcFile.toPath(), destFile.toPath(), copyOptions);
    }

    public static void copyFile(File srcFile, File destFile, CopyOption ... copyOptions) throws IOException {
        AssertTool.notNull(srcFile, "No srcFile File specified");
        AssertTool.notNull(destFile, "No destFile File specified");
        if (!srcFile.exists() || !srcFile.isFile()) {
            throw new IOException("File '" + srcFile + "' does not exist or is not a file");
        }
        FileTool.createParentDirectories(destFile);
        Files.copy(srcFile.toPath(), destFile.toPath(), copyOptions);
    }

    public static int copyFileData(String srcFilePath, String destFilePath) throws IOException {
        AssertTool.notNull(srcFilePath, "No srcFile File specified");
        AssertTool.notNull(destFilePath, "No destFile File specified");
        File srcFile = new File(srcFilePath);
        File destFile = new File(destFilePath);
        return IOTool.copy(Files.newInputStream(srcFile.toPath(), new OpenOption[0]), Files.newOutputStream(destFile.toPath(), new OpenOption[0]));
    }

    public static int copyFileData(File srcFile, File destFile) throws IOException {
        AssertTool.notNull(srcFile, "No srcFile File specified");
        AssertTool.notNull(destFile, "No destFile File specified");
        return IOTool.copy(Files.newInputStream(srcFile.toPath(), new OpenOption[0]), Files.newOutputStream(destFile.toPath(), new OpenOption[0]));
    }

    public static void writeLines(String filePath, Collection<?> lines) throws IOException {
        FileTool.writeLines(new File(filePath), null, lines, null, false);
    }

    public static void writeLines(String filePath, Collection<?> lines, boolean append) throws IOException {
        FileTool.writeLines(new File(filePath), null, lines, null, append);
    }

    public static void writeLines(File file, Charset charset, Collection<?> lines, String lineEnding, boolean append) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(FileTool.newOutputStream(file, append));){
            IOTool.writeLines(lines, lineEnding, out, charset);
        }
    }

    private static OutputStream newOutputStream(File file, boolean append) throws IOException {
        Path path = Objects.requireNonNull(file, "file not exists").toPath();
        ArrayList<OpenOption> optionList = new ArrayList<OpenOption>(Arrays.asList(append ? OPEN_OPTIONS_APPEND : OPEN_OPTIONS_TRUNCATE));
        return Files.newOutputStream(path, optionList.toArray(new OpenOption[0]));
    }

    public static void writeString(String filePath, String data) throws IOException {
        FileTool.writeString(new File(filePath), data, Charset.defaultCharset(), false);
    }

    public static void writeString(String filePath, String data, boolean append) throws IOException {
        FileTool.writeString(new File(filePath), data, Charset.defaultCharset(), append);
    }

    public static void writeString(File file, String data, Charset charset, boolean append) throws IOException {
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try (OutputStream out = FileTool.newOutputStream(file, append);){
            IOTool.writeString(data, out, charset);
        }
    }
}

