/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropTool {
    private static Logger logger = LoggerFactory.getLogger(PropTool.class);

    public static Properties loadProp(String resourcePath) {
        Properties prop = new Properties();
        if (resourcePath == null || resourcePath.trim().isEmpty()) {
            return prop;
        }
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);){
            if (input != null) {
                prop.load(input);
            }
        }
        catch (Exception e) {
            logger.error("PropTool loadProp error:", (Throwable)e);
        }
        return prop;
    }

    public static Properties loadFileProp(String fileName) {
        Properties prop = new Properties();
        if (fileName == null || fileName.trim().isEmpty()) {
            return prop;
        }
        Path path = Paths.get(fileName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return prop;
        }
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            prop.load(in);
        }
        catch (IOException e) {
            logger.error("PropTool loadFileProp error:", (Throwable)e);
        }
        return prop;
    }

    public static String getString(Properties prop, String key) {
        return prop.getProperty(key);
    }

    public static String getString(Properties prop, String key, String defaultValue) {
        String value = PropTool.getString(prop, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static int getInt(Properties prop, String key) {
        return Integer.parseInt(PropTool.getString(prop, key));
    }

    public static boolean getBoolean(Properties prop, String key) {
        return Boolean.valueOf(PropTool.getString(prop, key));
    }

    public static long getLong(Properties prop, String key) {
        return Long.valueOf(PropTool.getString(prop, key));
    }

    public static double getDouble(Properties prop, String key) {
        return Double.valueOf(PropTool.getString(prop, key));
    }
}

