/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import com.xxl.tool.core.AssertTool;
import com.xxl.tool.core.ClassTool;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class TypeTool {
    public static boolean isAssignable(Type superType, Type subType) {
        AssertTool.notNull(superType, "Left-hand side type must not be null");
        AssertTool.notNull(subType, "Right-hand side type must not be null");
        if (superType.equals(subType) || Object.class == superType) {
            return true;
        }
        if (superType instanceof Class) {
            Class lhsClass = (Class)superType;
            if (subType instanceof Class) {
                return ClassTool.isAssignable(lhsClass, (Class)subType);
            }
            if (subType instanceof ParameterizedType) {
                Type rhsRaw = ((ParameterizedType)subType).getRawType();
                if (rhsRaw instanceof Class) {
                    return ClassTool.isAssignable(lhsClass, (Class)rhsRaw);
                }
            } else if (lhsClass.isArray() && subType instanceof GenericArrayType) {
                Type rhsComponent = ((GenericArrayType)subType).getGenericComponentType();
                return TypeTool.isAssignable(lhsClass.getComponentType(), rhsComponent);
            }
        }
        if (superType instanceof ParameterizedType) {
            if (subType instanceof Class) {
                Type lhsRaw = ((ParameterizedType)superType).getRawType();
                if (lhsRaw instanceof Class) {
                    return ClassTool.isAssignable((Class)lhsRaw, (Class)subType);
                }
            } else if (subType instanceof ParameterizedType) {
                return TypeTool.isAssignable((ParameterizedType)superType, (ParameterizedType)subType);
            }
        }
        if (superType instanceof GenericArrayType) {
            Type lhsComponent = ((GenericArrayType)superType).getGenericComponentType();
            if (subType instanceof Class) {
                Class rhsClass = (Class)subType;
                if (rhsClass.isArray()) {
                    return TypeTool.isAssignable(lhsComponent, rhsClass.getComponentType());
                }
            } else if (subType instanceof GenericArrayType) {
                Type rhsComponent = ((GenericArrayType)subType).getGenericComponentType();
                return TypeTool.isAssignable(lhsComponent, rhsComponent);
            }
        }
        if (superType instanceof WildcardType) {
            return TypeTool.isAssignable((WildcardType)superType, subType);
        }
        return false;
    }
}

