/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.encrypt;

import com.xxl.tool.encrypt.HexTool;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;

public class SHA256Tool {
    private static final String SHA_256_ALGORITHM_NAME = "SHA-256";

    public static String sha256(String input) {
        return SHA256Tool.sha256(input.getBytes(StandardCharsets.UTF_8), null);
    }

    public static String sha256(String input, String salt) {
        byte[] saltBytes = salt != null ? salt.getBytes(StandardCharsets.UTF_8) : null;
        return SHA256Tool.sha256(input.getBytes(StandardCharsets.UTF_8), saltBytes);
    }

    public static String sha256(byte[] input, byte[] salt) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA_256_ALGORITHM_NAME);
            if (salt != null) {
                md.update(salt);
            }
            byte[] digest = md.digest(input);
            return HexTool.byteToHex(digest);
        }
        catch (Exception e) {
            throw new IllegalStateException("SHA256Tool#sha256 error, input:" + Arrays.toString(input), e);
        }
    }
}

