/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.excel.util;

import com.xxl.tool.excel.annotation.ExcelField;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class FieldReflectionUtil {
    private FieldReflectionUtil() {
    }

    public static Byte parseByte(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseByte but input illegal input=" + value, e);
        }
    }

    public static Boolean parseBoolean(String value) {
        value = value.replaceAll("\u3000", "");
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new RuntimeException("parseBoolean but input illegal input=" + value);
    }

    public static Integer parseInt(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseInt but input illegal input=" + value, e);
        }
    }

    public static Short parseShort(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Short.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseShort but input illegal input=" + value, e);
        }
    }

    public static Long parseLong(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseLong but input illegal input=" + value, e);
        }
    }

    public static Float parseFloat(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseFloat but input illegal input=" + value, e);
        }
    }

    public static Double parseDouble(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseDouble but input illegal input=" + value, e);
        }
    }

    public static Date parseDate(String value, ExcelField excelField) {
        try {
            String datePattern = "yyyy-MM-dd HH:mm:ss";
            if (excelField != null) {
                datePattern = excelField.dateformat();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
            return dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException("parseDate but input illegal input=" + value, e);
        }
    }

    public static Object parseValue(Field field, String value) {
        Class<?> fieldType = field.getType();
        ExcelField excelField = field.getAnnotation(ExcelField.class);
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        value = value.trim();
        if (Boolean.class.equals(fieldType) || Boolean.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseBoolean(value);
        }
        if (String.class.equals(fieldType)) {
            return value;
        }
        if (Short.class.equals(fieldType) || Short.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseShort(value);
        }
        if (Integer.class.equals(fieldType) || Integer.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseInt(value);
        }
        if (Long.class.equals(fieldType) || Long.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseLong(value);
        }
        if (Float.class.equals(fieldType) || Float.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseFloat(value);
        }
        if (Double.class.equals(fieldType) || Double.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseDouble(value);
        }
        if (Date.class.equals(fieldType)) {
            return FieldReflectionUtil.parseDate(value, excelField);
        }
        throw new RuntimeException("request illeagal type, type must be Integer not int Long not long etc, type=" + fieldType);
    }

    public static String formatValue(Field field, Object value) {
        Class<?> fieldType = field.getType();
        ExcelField excelField = field.getAnnotation(ExcelField.class);
        if (value == null) {
            return null;
        }
        if (Boolean.class.equals(fieldType) || Boolean.TYPE.equals(fieldType)) {
            return String.valueOf(value);
        }
        if (String.class.equals(fieldType)) {
            return String.valueOf(value);
        }
        if (Short.class.equals(fieldType) || Short.TYPE.equals(fieldType)) {
            return String.valueOf(value);
        }
        if (Integer.class.equals(fieldType) || Integer.TYPE.equals(fieldType)) {
            return String.valueOf(value);
        }
        if (Long.class.equals(fieldType) || Long.TYPE.equals(fieldType)) {
            return String.valueOf(value);
        }
        if (Float.class.equals(fieldType) || Float.TYPE.equals(fieldType)) {
            return String.valueOf(value);
        }
        if (Double.class.equals(fieldType) || Double.TYPE.equals(fieldType)) {
            return String.valueOf(value);
        }
        if (Date.class.equals(fieldType)) {
            String datePattern = "yyyy-MM-dd HH:mm:ss";
            if (excelField != null && excelField.dateformat() != null) {
                datePattern = excelField.dateformat();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
            return dateFormat.format(value);
        }
        throw new RuntimeException("request illeagal type, type must be Integer not int Long not long etc, type=" + fieldType);
    }
}

