/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.io;

import com.xxl.tool.core.AssertTool;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class IOTool {
    public static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        AssertTool.notNull(in, "No InputStream specified");
        AssertTool.notNull(out, "No OutputStream specified");
        try {
            int bytesRead;
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            IOTool.close(in);
            IOTool.close(out);
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        AssertTool.notNull(in, "No input byte array specified");
        AssertTool.notNull(out, "No OutputStream specified");
        try {
            out.write(in);
        }
        finally {
            IOTool.close(out);
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IOTool.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyToString(InputStream in, Charset charset) throws IOException {
        if (in == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(4096);
        InputStreamReader reader = null;
        try {
            int charsRead;
            reader = new InputStreamReader(in, charset);
            char[] buffer = new char[4096];
            while ((charsRead = reader.read(buffer)) != -1) {
                out.append(buffer, 0, charsRead);
            }
        }
        finally {
            IOTool.close(in);
            IOTool.close(reader);
        }
        return out.toString();
    }

    private static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeLines(Collection<?> lines, OutputStream output) throws IOException {
        IOTool.writeLines(lines, null, output, null);
    }

    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output, Charset charset) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = System.lineSeparator();
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            charset = StandardCharsets.UTF_16BE;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        byte[] eolBytes = lineEnding.getBytes(charset);
        for (Object line : lines) {
            if (line != null) {
                IOTool.writeString(line.toString(), output, charset);
            }
            output.write(eolBytes);
        }
    }

    public static void writeString(String data, OutputStream output) throws IOException {
        IOTool.writeString(data, output, StandardCharsets.UTF_8);
    }

    public static void writeString(String data, OutputStream output, Charset charset) throws IOException {
        if (data == null) {
            return;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        Channels.newChannel(output).write(charset.encode(data));
    }
}

