/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.pipeline;

import com.xxl.tool.core.CollectionTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.pipeline.Pipeline;
import com.xxl.tool.pipeline.PipelineStatus;
import com.xxl.tool.response.Response;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PipelineExecutor.class);
    private final Map<String, Pipeline> pipelineMap = new ConcurrentHashMap<String, Pipeline>();

    public boolean registry(Pipeline pipeline) {
        if (pipeline == null) {
            logger.debug("PipelineExecutor registry fail, pipeline is null");
            return false;
        }
        if (CollectionTool.isEmpty(pipeline.getHandlerList())) {
            logger.debug("PipelineExecutor registry fail, pipeline[{}] is empty", (Object)pipeline);
            return false;
        }
        this.pipelineMap.put(pipeline.getName(), pipeline);
        return true;
    }

    public Response<Object> execute(String pipelineName, Object request) {
        return this.execute(pipelineName, request, null);
    }

    private Response<Object> execute(String pipelineName, Object request, ConcurrentMap<String, Object> contextMap) {
        if (StringTool.isBlank(pipelineName)) {
            logger.debug("PipelineExecutor execute fail, pipelineName is null");
            return null;
        }
        Pipeline pipeline = this.pipelineMap.get(pipelineName);
        if (pipeline == null) {
            logger.debug("PipelineExecutor execute fail, pipeline[{}] is null", (Object)pipelineName);
            return null;
        }
        if (PipelineStatus.RUNTIME != PipelineStatus.findByStatus(pipeline.getStatus())) {
            logger.debug("PipelineExecutor execute fail, pipeline[{}] is not running", (Object)pipelineName);
            return null;
        }
        return pipeline.process(request, contextMap);
    }
}

