/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.signer;

import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopCredentialsWithoutSign;
import com.yeepay.yop.sdk.auth.credentials.YopOauth2Credentials;
import com.yeepay.yop.sdk.base.auth.signer.YopSigner;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.security.SignerTypeEnum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopOauth2Signer
implements YopSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopOauth2Signer.class);
    private static final String AUTHORIZATION_PREFIX = "Bearer ";

    @Override
    public List<String> supportSignerAlg() {
        return Lists.newArrayList((Object[])new String[]{SignerTypeEnum.OAUTH2.name()});
    }

    @Override
    public void sign(Request<? extends BaseRequest> request, YopCredentials<?> credentials, SignOptions options) {
        if (null == request) {
            throw new YopClientException("ReqParam Illegal, Request IsNull");
        }
        if (credentials == null || credentials instanceof YopCredentialsWithoutSign) {
            return;
        }
        if (!(credentials instanceof YopOauth2Credentials)) {
            throw new YopClientException("ReqParam Illegal, YopCredentials IsNotYopOauth2Credentials, type:" + credentials.getClass().getSimpleName());
        }
        String secretKey = (String)credentials.getCredential();
        String authorizationHeader = AUTHORIZATION_PREFIX + secretKey;
        request.addHeader("Authorization", authorizationHeader);
    }
}

