/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.AbstractEncryptOptionsEnhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.ClientUtils;
import com.yeepay.yop.sdk.utils.Encodes;

public class RsaEnhancer
extends AbstractEncryptOptionsEnhancer {
    private final String provider;
    private final String env;
    private final String appKey;

    public RsaEnhancer(String appKey) {
        this.appKey = appKey;
        this.provider = "";
        this.env = "";
    }

    public RsaEnhancer(String provider, String env, String appKey) {
        this.appKey = appKey;
        this.provider = provider;
        this.env = env;
    }

    public EncryptOptions enhance(EncryptOptions source) {
        if (!this.checkForEnhance(source)) {
            return source;
        }
        YopSymmetricCredentials sourceCredentials = (YopSymmetricCredentials)source.getCredentials();
        String credentialStr = sourceCredentials.getCredential();
        byte[] credentialBytes = Encodes.decodeBase64(credentialStr);
        YopPlatformCredentials yopPlatformCredentials = ClientUtils.getCurrentPlatformCredentialsProvider().getLatestCredentials(this.provider, this.env, this.appKey, CertTypeEnum.RSA2048.getValue(), null);
        source.setEncryptedCredentials(YopEncryptorFactory.getEncryptor("RSA").encryptToBase64(credentialBytes, new EncryptOptions((Object)yopPlatformCredentials)));
        source.setCredentialsAlg("RSA");
        source.setCredentials((Object)new YopSymmetricCredentials(this.appKey, credentialStr));
        source.enhance("YOP_PLATFORM_CERT_SERIAL_NO", (Object)"");
        return source;
    }
}

