/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProvider;
import com.yeepay.yop.sdk.base.security.encrypt.AbstractEncryptOptionsEnhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.ClientUtils;
import com.yeepay.yop.sdk.utils.Encodes;
import org.apache.commons.lang3.StringUtils;

public class Sm2Enhancer
extends AbstractEncryptOptionsEnhancer {
    private final String provider;
    private final String env;
    private final String appKey;
    private final String serialNo;
    private final String serverRoot;

    public Sm2Enhancer(String appKey) {
        this.appKey = appKey;
        this.serialNo = "";
        this.serverRoot = "";
        this.provider = "";
        this.env = "";
    }

    public Sm2Enhancer(String appKey, String serialNo) {
        this.appKey = appKey;
        this.serialNo = serialNo;
        this.serverRoot = "";
        this.provider = "";
        this.env = "";
    }

    public Sm2Enhancer(String appKey, String serialNo, String serverRoot) {
        this.appKey = appKey;
        this.serialNo = serialNo;
        this.serverRoot = serverRoot;
        this.provider = "";
        this.env = "";
    }

    public Sm2Enhancer(String provider, String env, String appKey, String serialNo, String serverRoot) {
        this.appKey = appKey;
        this.serialNo = serialNo;
        this.serverRoot = serverRoot;
        this.provider = provider;
        this.env = env;
    }

    public EncryptOptions enhance(EncryptOptions source) {
        if (!this.checkForEnhance(source)) {
            return source;
        }
        YopSymmetricCredentials sourceCredentials = (YopSymmetricCredentials)source.getCredentials();
        String credentialStr = sourceCredentials.getCredential();
        byte[] credentialBytes = Encodes.decodeBase64(credentialStr);
        YopPlatformCredentialsProvider platformCredentialsProvider = ClientUtils.getCurrentPlatformCredentialsProvider();
        YopPlatformCredentials platformCredentials = StringUtils.isNotBlank((CharSequence)this.serialNo) ? platformCredentialsProvider.getCredentials(this.provider, this.env, this.appKey, this.serialNo, this.serverRoot) : platformCredentialsProvider.getLatestCredentials(this.provider, this.env, this.appKey, CertTypeEnum.SM2.getValue(), this.serverRoot);
        if (null == platformCredentials) {
            throw new YopClientException("ConfigProblem, YopPlatformCredentials NotFound to Enhance EncryptOptions, appKey:" + this.appKey + ", serialNo:" + this.serialNo);
        }
        source.setEncryptedCredentials(YopEncryptorFactory.getEncryptor("SM2").encryptToBase64(credentialBytes, new EncryptOptions((Object)platformCredentials)));
        source.setCredentialsAlg("SM2");
        source.setCredentials((Object)new YopSymmetricCredentials(this.appKey, credentialStr));
        source.enhance("YOP_PLATFORM_CERT_SERIAL_NO", (Object)platformCredentials.getSerialNo());
        return source;
    }
}

