/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client;

import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProvider;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqRegistry;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.client.support.ClientConfigurationSupport;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProvider;
import com.yeepay.yop.sdk.utils.ClientUtils;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceClientBuilder<SubClass extends AbstractServiceClientBuilder, ServiceInterfaceToBuild> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceClientBuilder.class);
    private String clientId;
    private boolean inner;
    private String provider;
    private String env;
    private YopCredentialsProvider credentialsProvider;
    private YopSdkConfigProvider yopSdkConfigProvider;
    private YopPlatformCredentialsProvider platformCredentialsProvider;
    private String endpoint;
    private List<URI> preferredEndPoint;
    private String yosEndPoint;
    private List<URI> preferredYosEndPoint;
    private String sandboxEndPoint;
    private ClientConfiguration clientConfiguration;
    private Map<URI, Integer> endPointWeightMap;
    private ServiceInterfaceToBuild clientInst;

    public final ServiceInterfaceToBuild build() {
        this.provider = StringUtils.defaultString((String)this.provider, (String)"");
        this.env = StringUtils.defaultString((String)this.env, (String)"");
        if (null == this.yopSdkConfigProvider) {
            this.yopSdkConfigProvider = YopSdkConfigProviderRegistry.getProvider();
        }
        if (null == this.credentialsProvider) {
            this.credentialsProvider = YopCredentialsProviderRegistry.getProvider();
        }
        if (null == this.platformCredentialsProvider) {
            this.platformCredentialsProvider = YopPlatformCredentialsProviderRegistry.getProvider();
        }
        YopSdkConfig yopSdkConfig = this.yopSdkConfigProvider.getConfig(this.provider, this.env);
        if (null == this.clientConfiguration) {
            this.clientConfiguration = ClientConfigurationSupport.getClientConfiguration(yopSdkConfig);
        }
        HashMap<URI, Integer> weightMap = new HashMap<URI, Integer>();
        if (CollectionUtils.isEmpty(this.preferredEndPoint)) {
            List<Object> list = this.preferredEndPoint = CollectionUtils.isNotEmpty((Collection)yopSdkConfig.getPreferredServerRoots()) ? yopSdkConfig.getPreferredServerRoots().stream().map(uriStr -> this.parseWeightedURI((String)uriStr, (Map<URI, Integer>)weightMap)).collect(Collectors.toList()) : Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(this.preferredYosEndPoint)) {
            List<Object> list = this.preferredYosEndPoint = CollectionUtils.isNotEmpty((Collection)yopSdkConfig.getPreferredYosServerRoots()) ? yopSdkConfig.getPreferredYosServerRoots().stream().map(uriStr -> this.parseWeightedURI((String)uriStr, (Map<URI, Integer>)weightMap)).collect(Collectors.toList()) : Collections.emptyList();
        }
        if (MapUtils.isNotEmpty(this.endPointWeightMap)) {
            this.endPointWeightMap.forEach((uri, weight) -> {
                if (weight > 0) {
                    weightMap.put((URI)uri, (Integer)weight);
                }
            });
        }
        ClientParams clientParams = ClientParams.Builder.builder().withInner(this.inner).withProvider(this.provider).withEnv(this.env).withCredentialsProvider(this.credentialsProvider).withYopSdkConfigProvider(this.yopSdkConfigProvider).withPlatformCredentialsProvider(this.platformCredentialsProvider).withClientConfiguration(this.clientConfiguration).withEndPoint(this.endpoint == null ? URI.create((String)StringUtils.defaultIfBlank((CharSequence)yopSdkConfig.getServerRoot(), (CharSequence)"https://openapi.yeepay.com/yop-center")) : URI.create(this.endpoint)).withYosEndPoint(this.yosEndPoint == null ? URI.create((String)StringUtils.defaultIfBlank((CharSequence)yopSdkConfig.getYosServerRoot(), (CharSequence)"https://yos.yeepay.com/yop-center")) : URI.create(this.yosEndPoint)).withPreferredEndPoint(this.preferredEndPoint).withPreferredYosEndPoint(this.preferredYosEndPoint).withEndPointWeightMap(weightMap).withSandboxEndPoint(this.sandboxEndPoint == null ? URI.create((String)StringUtils.defaultIfBlank((CharSequence)yopSdkConfig.getSandboxServerRoot(), (CharSequence)"https://sandbox.yeepay.com/yop-center")) : URI.create(this.sandboxEndPoint)).withAuthorizationReqRegistry(this.authorizationReqRegistry()).build();
        if (StringUtils.isBlank((CharSequence)this.clientId)) {
            String clientIdSuffix = ClientUtils.computeClientIdSuffix(clientParams);
            SubClass subclass = this.getSubclass();
            String clientBuilderClass = subclass.getClass().getCanonicalName();
            this.clientId = clientBuilderClass + ":" + clientIdSuffix;
        }
        clientParams.setClientId(this.clientId);
        Object buildClient = ClientUtils.getOrBuildClientInst(clientParams, this::build);
        this.clientInst = buildClient;
        ClientUtils.cacheClientBuilder(this.clientId, this);
        return (ServiceInterfaceToBuild)buildClient;
    }

    private URI parseWeightedURI(String uriStr, Map<URI, Integer> weightMap) {
        if (uriStr.contains(",")) {
            String[] uriWeight = uriStr.split(",");
            URI uri = URI.create(uriWeight[0]);
            try {
                Integer weight = Integer.valueOf(uriWeight[1]);
                if (weight > 0) {
                    weightMap.put(uri, weight);
                }
            }
            catch (Exception e) {
                LOGGER.warn("parse server root weight error, uri: {}", (Object)uriStr);
            }
            return uri;
        }
        return URI.create(uriStr);
    }

    private SubClass getSubclass() {
        return (SubClass)this;
    }

    public ServiceInterfaceToBuild getClientInst() {
        return this.clientInst;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getEnv() {
        return this.env;
    }

    public YopCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public YopSdkConfigProvider getYopSdkConfigProvider() {
        return this.yopSdkConfigProvider;
    }

    public YopPlatformCredentialsProvider getPlatformCredentialsProvider() {
        return this.platformCredentialsProvider;
    }

    public SubClass withCredentialsProvider(YopCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this.getSubclass();
    }

    public SubClass withClientId(String clientId) {
        this.clientId = clientId;
        return this.getSubclass();
    }

    public SubClass withInner(boolean inner) {
        this.inner = inner;
        return this.getSubclass();
    }

    public SubClass withProvider(String provider) {
        this.provider = provider;
        return this.getSubclass();
    }

    public SubClass withEnv(String env) {
        this.env = env;
        return this.getSubclass();
    }

    public SubClass withYopSdkConfigProvider(YopSdkConfigProvider yopSdkConfigProvider) {
        this.yopSdkConfigProvider = yopSdkConfigProvider;
        return this.getSubclass();
    }

    public SubClass withPlatformCredentialsProvider(YopPlatformCredentialsProvider platformCredentialsProvider) {
        this.platformCredentialsProvider = platformCredentialsProvider;
        return this.getSubclass();
    }

    public SubClass withClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        return this.getSubclass();
    }

    public SubClass withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this.getSubclass();
    }

    public SubClass withPreferredEndPoint(List<URI> preferredEndPoint) {
        this.preferredEndPoint = preferredEndPoint;
        return this.getSubclass();
    }

    public SubClass withYosEndpoint(String yosEndpoint) {
        this.yosEndPoint = yosEndpoint;
        return this.getSubclass();
    }

    public SubClass withPreferredYosEndPoint(List<URI> preferredYosEndPoint) {
        this.preferredYosEndPoint = preferredYosEndPoint;
        return this.getSubclass();
    }

    public SubClass withSandboxEndPoint(String sandboxEndPoint) {
        this.sandboxEndPoint = sandboxEndPoint;
        return this.getSubclass();
    }

    public SubClass withEndPointWeightMap(Map<URI, Integer> endPointWeightMap) {
        this.endPointWeightMap = endPointWeightMap;
        return this.getSubclass();
    }

    protected abstract AuthorizationReqRegistry authorizationReqRegistry();

    protected abstract ServiceInterfaceToBuild build(ClientParams var1);
}

