/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.router;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.client.router.AbstractGateWayRouter;
import com.yeepay.yop.sdk.client.router.RouteUtils;
import com.yeepay.yop.sdk.client.router.ServerRootSpace;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightGateWayRouter
extends AbstractGateWayRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightGateWayRouter.class);

    public WeightGateWayRouter(ServerRootSpace space) {
        super(space);
    }

    @Override
    protected AbstractGateWayRouter.ServerRootRouting initServerRootRouting(ServerRootSpace space) {
        List randomSandboxList;
        List weightYosList;
        if (null == space.getUriWeight() || space.getUriWeight().isEmpty()) {
            return super.initServerRootRouting(space);
        }
        ConcurrentMap mainServers = Maps.newConcurrentMap();
        ConcurrentMap backupServers = Maps.newConcurrentMap();
        List weightCommonList = RouteUtils.weightList(space.getPreferredEndPoint().stream().map(p -> new RouteUtils.WeightAble<URI>((URI)p, space.getUriWeight().getOrDefault(p, 0))).collect(Collectors.toList()));
        if (this.recordMainServer((URI)weightCommonList.remove(0).getT(), AbstractGateWayRouter.ServerRootType.COMMON, mainServers)) {
            backupServers.put(AbstractGateWayRouter.ServerRootType.COMMON, weightCommonList.stream().map(RouteUtils.WeightAble::getT).collect(Collectors.toList()));
        }
        if (this.recordMainServer((URI)(weightYosList = RouteUtils.weightList((CollectionUtils.isEmpty(space.getPreferredYosEndPoint()) ? Lists.newArrayList((Object[])new URI[]{space.getYosServerRoot()}) : space.getPreferredYosEndPoint()).stream().map(p -> new RouteUtils.WeightAble<URI>((URI)p, space.getUriWeight().getOrDefault(p, 0))).collect(Collectors.toList()))).remove(0).getT(), AbstractGateWayRouter.ServerRootType.YOS, mainServers)) {
            backupServers.put(AbstractGateWayRouter.ServerRootType.YOS, weightYosList.stream().map(RouteUtils.WeightAble::getT).collect(Collectors.toList()));
        }
        if (this.recordMainServer((URI)(randomSandboxList = RouteUtils.randomList(Lists.newArrayList((Object[])new URI[]{space.getSandboxServerRoot()}))).remove(0), AbstractGateWayRouter.ServerRootType.SANDBOX, mainServers)) {
            backupServers.put(AbstractGateWayRouter.ServerRootType.SANDBOX, randomSandboxList);
        }
        return new AbstractGateWayRouter.ServerRootRouting(mainServers, backupServers);
    }
}

