/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.AbstractGpgMojo;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.apache.maven.plugins.gpg.ArtifactCollectorSPI;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="sign-deployed", requiresProject=false, threadSafe=true)
public class SignDeployedMojo
extends AbstractGpgMojo {
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="repositoryId", required=true)
    private String repositoryId;
    @Parameter(property="javadoc", defaultValue="true", required=true)
    private boolean javadoc;
    @Parameter(property="sources", defaultValue="true", required=true)
    private boolean sources;
    @Parameter(property="artifacts")
    private String artifacts;
    private final RepositorySystem repositorySystem;
    private final Map<String, ArtifactCollectorSPI> artifactCollectors;

    @Inject
    public SignDeployedMojo(RepositorySystem repositorySystem, Map<String, ArtifactCollectorSPI> artifactCollectors) {
        this.repositorySystem = repositorySystem;
        this.artifactCollectors = artifactCollectors;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.settings.isOffline()) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
        Path tempDirectory = null;
        Set<Object> artifacts = new HashSet<Object>();
        try {
            tempDirectory = Files.createTempDirectory("gpg-sign-deployed", new FileAttribute[0]);
            this.getLog().debug((CharSequence)("Using temp directory " + tempDirectory));
            DefaultRepositorySystemSession signingSession = new DefaultRepositorySystemSession(this.session.getRepositorySession());
            signingSession.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)signingSession, new LocalRepository(tempDirectory.toFile())));
            RemoteRepository deploymentRepository = this.repositorySystem.newDeploymentRepository((RepositorySystemSession)signingSession, new RemoteRepository.Builder(this.repositoryId, "default", this.url).build());
            this.getLog().debug((CharSequence)"Collecting artifacts for signing...");
            artifacts.addAll(this.collectArtifacts((RepositorySystemSession)signingSession, deploymentRepository));
            this.getLog().info((CharSequence)("Collected " + artifacts.size() + " artifact" + (artifacts.size() > 1 ? "s" : "") + " for signing"));
            if (this.sources || this.javadoc) {
                this.getLog().debug((CharSequence)"Adding additional artifacts...");
                ArrayList<SubArtifact> additions = new ArrayList<SubArtifact>();
                for (Artifact artifact : artifacts) {
                    if (!artifact.getClassifier().isEmpty()) continue;
                    if (this.sources) {
                        additions.add(new SubArtifact(artifact, "sources", "jar"));
                    }
                    if (!this.javadoc) continue;
                    additions.add(new SubArtifact(artifact, "javadoc", "jar"));
                }
                artifacts.addAll(additions);
            }
            this.getLog().info((CharSequence)("Resolving " + artifacts.size() + " artifact" + (artifacts.size() > 1 ? "s" : "") + " artifacts for signing..."));
            List results = this.repositorySystem.resolveArtifacts((RepositorySystemSession)signingSession, (Collection)artifacts.stream().map(a -> new ArtifactRequest(a, Collections.singletonList(deploymentRepository), "gpg")).collect(Collectors.toList()));
            artifacts = results.stream().map(ArtifactResult::getArtifact).collect(Collectors.toSet());
            AbstractGpgSigner signer = this.newSigner(null);
            signer.setOutputDirectory(tempDirectory.toFile());
            this.getLog().info((CharSequence)("Signer '" + signer.signerName() + "' is signing " + artifacts.size() + " file" + (artifacts.size() > 1 ? "s" : "") + " with key " + signer.getKeyInfo()));
            HashSet<Artifact> hashSet = new HashSet<Artifact>();
            for (Artifact artifact : artifacts) {
                hashSet.add(new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension() + ".asc", artifact.getVersion()).setFile(signer.generateSignatureForArtifact(artifact.getFile())));
            }
            this.getLog().info((CharSequence)"Deploying artifact signatures...");
            this.repositorySystem.deploy((RepositorySystemSession)signingSession, new DeployRequest().setRepository(deploymentRepository).setArtifacts(hashSet).setTrace(RequestTrace.newChild(null, (Object)((Object)this))));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO error: " + e.getMessage(), (Exception)e);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error resolving deployed artifacts " + artifacts + ": " + e.getMessage(), (Exception)((Object)e));
        }
        catch (DeploymentException e) {
            throw new MojoExecutionException("Error deploying signatures: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (tempDirectory != null) {
                this.getLog().info((CharSequence)"Cleaning up...");
                try {
                    FileUtils.deleteDirectory((File)tempDirectory.toFile());
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Could not clean up temp directory " + tempDirectory));
                }
            }
        }
    }

    protected Collection<Artifact> collectArtifacts(RepositorySystemSession session, RemoteRepository remoteRepository) throws IOException {
        ArtifactCollectorSPI artifactCollector;
        Collection result = null;
        Iterator<ArtifactCollectorSPI> iterator = this.artifactCollectors.values().iterator();
        while (iterator.hasNext() && (result = (artifactCollector = iterator.next()).collectArtifacts(session, remoteRepository)) == null) {
        }
        if (result == null && this.artifacts != null) {
            block12: {
                try {
                    Path path = Paths.get(this.artifacts, new String[0]);
                    if (!Files.isRegularFile(path, new LinkOption[0])) break block12;
                    try (Stream<String> lines = Files.lines(path);){
                        result = lines.filter(l -> !l.isEmpty() && !l.startsWith("#")).map(DefaultArtifact::new).collect(Collectors.toSet());
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
            if (result == null) {
                result = Arrays.stream(this.artifacts.split(",")).map(DefaultArtifact::new).collect(Collectors.toSet());
            }
        }
        if (result == null) {
            throw new IllegalStateException("No source to collect from (set -Dartifacts=g:a:v... or add collector)");
        }
        return result;
    }
}

