/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat.v6;

import org.apache.catalina.LifecycleException;
import org.jasig.cas.client.tomcat.v6.AbstractCasAuthenticator;
import org.jasig.cas.client.tomcat.v6.ProxyCallbackValve;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;

public final class Cas20ProxyCasAuthenticator
extends AbstractCasAuthenticator {
    public static final String AUTH_METHOD = "CAS20-PROXY";
    private static final String NAME = Cas20ProxyCasAuthenticator.class.getName();
    private Cas20ProxyTicketValidator ticketValidator;
    private boolean acceptAnyProxy;
    private String allowedProxyChains;

    public void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public void setAllowedProxyChains(String allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }

    protected TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    protected String getAuthenticationMethod() {
        return AUTH_METHOD;
    }

    protected String getName() {
        return NAME;
    }

    public void start() throws LifecycleException {
        super.start();
        this.ticketValidator = new Cas20ProxyTicketValidator(this.getCasServerUrlPrefix());
        this.ticketValidator.setRenew(this.isRenew());
        this.ticketValidator.setProxyCallbackUrl(this.getProxyCallbackUrl());
        this.ticketValidator.setProxyGrantingTicketStorage(ProxyCallbackValve.getProxyGrantingTicketStorage());
        this.ticketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        this.ticketValidator.setAllowedProxyChains(CommonUtils.createProxyList((String)this.allowedProxyChains));
        if (this.getEncoding() != null) {
            this.ticketValidator.setEncoding(this.getEncoding());
        }
        this.lifecycle.fireLifecycleEvent("after_start", null);
        this.logger.info("Startup completed.");
    }
}

