/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat.v6;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.tomcat.v6.AbstractLifecycleValve;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;

public final class ProxyCallbackValve
extends AbstractLifecycleValve {
    private static final String NAME = ProxyCallbackValve.class.getName();
    private static ProxyGrantingTicketStorage PROXY_GRANTING_TICKET_STORAGE;
    private String proxyGrantingTicketStorageClass;
    private String proxyCallbackUrl;

    public static ProxyGrantingTicketStorage getProxyGrantingTicketStorage() {
        return PROXY_GRANTING_TICKET_STORAGE;
    }

    public void setProxyGrantingTicketStorageClass(String proxyGrantingTicketStorageClass) {
        this.proxyGrantingTicketStorageClass = proxyGrantingTicketStorageClass;
    }

    public void setProxyCallbackUrl(String proxyCallbackUrl) {
        this.proxyCallbackUrl = proxyCallbackUrl;
    }

    public void start() throws LifecycleException {
        super.start();
        try {
            CommonUtils.assertNotNull((Object)this.proxyCallbackUrl, (String)"the proxy callback url cannot  be null");
            CommonUtils.assertTrue((boolean)this.proxyCallbackUrl.startsWith("/"), (String)"proxy callback url must start with \"/\"");
            PROXY_GRANTING_TICKET_STORAGE = (ProxyGrantingTicketStorage)ReflectUtils.newInstance((String)this.proxyGrantingTicketStorageClass, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        this.logger.info("Startup completed.");
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.proxyCallbackUrl.equals(request.getRequestURI())) {
            this.logger.debug("Processing proxy callback request.");
            CommonUtils.readAndRespondToProxyReceptorRequest((HttpServletRequest)request, (HttpServletResponse)response, (ProxyGrantingTicketStorage)PROXY_GRANTING_TICKET_STORAGE);
            return;
        }
        this.getNext().invoke(request, response);
    }

    protected String getName() {
        return NAME;
    }
}

