/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat.v6;

import org.apache.catalina.LifecycleException;
import org.jasig.cas.client.tomcat.v6.AbstractAuthenticator;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidator;

public class Saml11Authenticator
extends AbstractAuthenticator {
    public static final String AUTH_METHOD = "SAML11";
    private static final String NAME = Saml11Authenticator.class.getName();
    private Saml11TicketValidator ticketValidator;
    private int tolerance = -1;

    public void setTolerance(int ms) {
        this.tolerance = ms;
    }

    public void start() throws LifecycleException {
        super.start();
        this.ticketValidator = new Saml11TicketValidator(this.getCasServerUrlPrefix());
        if (this.tolerance > -1) {
            this.ticketValidator.setTolerance((long)this.tolerance);
        }
        if (this.getEncoding() != null) {
            this.ticketValidator.setEncoding(this.getEncoding());
        }
        this.ticketValidator.setRenew(this.isRenew());
        this.lifecycle.fireLifecycleEvent("after_start", null);
        this.logger.info("Startup completed.");
    }

    protected TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    protected String getAuthenticationMethod() {
        return AUTH_METHOD;
    }

    protected String getArtifactParameterName() {
        return "SAMLart";
    }

    protected String getServiceParameterName() {
        return "TARGET";
    }

    protected String getName() {
        return NAME;
    }
}

