/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.server.ServerWebExchange;

public final class RequestMethodsRequestCondition
extends AbstractRequestCondition<RequestMethodsRequestCondition> {
    private static final Map<HttpMethod, RequestMethodsRequestCondition> requestMethodConditionCache = CollectionUtils.newHashMap((int)RequestMethod.values().length);
    private final Set<RequestMethod> methods;

    public RequestMethodsRequestCondition(RequestMethod ... requestMethods) {
        this.methods = ObjectUtils.isEmpty((Object[])requestMethods) ? Collections.emptySet() : new LinkedHashSet<RequestMethod>(Arrays.asList(requestMethods));
    }

    private RequestMethodsRequestCondition(Set<RequestMethod> requestMethods) {
        this.methods = requestMethods;
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    @Override
    protected Collection<RequestMethod> getContent() {
        return this.methods;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public RequestMethodsRequestCondition combine(RequestMethodsRequestCondition other) {
        if (this.isEmpty() && other.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        LinkedHashSet<RequestMethod> set = new LinkedHashSet<RequestMethod>(this.methods);
        set.addAll(other.methods);
        return new RequestMethodsRequestCondition(set);
    }

    @Override
    @Nullable
    public RequestMethodsRequestCondition getMatchingCondition(ServerWebExchange exchange2) {
        if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange2.getRequest())) {
            return this.matchPreFlight(exchange2.getRequest());
        }
        if (this.getMethods().isEmpty()) {
            if (HttpMethod.OPTIONS.equals((Object)exchange2.getRequest().getMethod())) {
                return null;
            }
            return this;
        }
        return this.matchRequestMethod(exchange2.getRequest().getMethod());
    }

    @Nullable
    private RequestMethodsRequestCondition matchPreFlight(ServerHttpRequest request) {
        if (this.getMethods().isEmpty()) {
            return this;
        }
        HttpMethod expectedMethod = request.getHeaders().getAccessControlRequestMethod();
        return expectedMethod != null ? this.matchRequestMethod(expectedMethod) : null;
    }

    @Nullable
    private RequestMethodsRequestCondition matchRequestMethod(HttpMethod httpMethod) {
        RequestMethod requestMethod = RequestMethod.resolve((HttpMethod)httpMethod);
        if (requestMethod != null) {
            if (this.getMethods().contains(requestMethod)) {
                return requestMethodConditionCache.get(httpMethod);
            }
            if (requestMethod.equals((Object)RequestMethod.HEAD) && this.getMethods().contains(RequestMethod.GET)) {
                return requestMethodConditionCache.get(HttpMethod.GET);
            }
        }
        return null;
    }

    @Override
    public int compareTo(RequestMethodsRequestCondition other, ServerWebExchange exchange2) {
        if (other.methods.size() != this.methods.size()) {
            return other.methods.size() - this.methods.size();
        }
        if (this.methods.size() == 1) {
            if (this.methods.contains(RequestMethod.HEAD) && other.methods.contains(RequestMethod.GET)) {
                return -1;
            }
            if (this.methods.contains(RequestMethod.GET) && other.methods.contains(RequestMethod.HEAD)) {
                return 1;
            }
        }
        return 0;
    }

    static {
        for (RequestMethod requestMethod : RequestMethod.values()) {
            requestMethodConditionCache.put(requestMethod.asHttpMethod(), new RequestMethodsRequestCondition(requestMethod));
        }
    }
}

