/*
 * Decompiled with CFR 0.152.
 */
package com.jte.cloud.platform.notify.utils;

import com.alibaba.fastjson.JSON;
import com.jte.cloud.platform.common.ResultCode;
import com.jte.cloud.platform.notify.feign.alarm.AlarmEmailClient;
import com.jte.cloud.platform.notify.feign.alarm.AlarmSmsClient;
import com.jte.cloud.platform.notify.utils.MonitorNotifyUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class MonitorNotifyUtilsImpl
implements MonitorNotifyUtils {
    private static final Logger log = LoggerFactory.getLogger(MonitorNotifyUtilsImpl.class);
    @Autowired
    private AlarmEmailClient alarmEmailClient;
    @Autowired
    private AlarmSmsClient alarmSmsClient;
    @Autowired
    private Environment environment;
    @Value(value="${alarm.sms.username}")
    private String smsUsername;
    @Value(value="${alarm.sms.password}")
    private String smsPassword;
    @Value(value="${alarm.sms.phones}")
    private String smsPhones;
    @Value(value="${alarm.email.apiUser}")
    private String emailApiUser;
    @Value(value="${alarm.email.apiKey}")
    private String emailApiKey;
    @Value(value="${alarm.email.from}")
    private String emailFrom;
    @Value(value="${alarm.email.to}")
    private String emailTo;

    @Override
    public void notifyError(String content, String templateInvokeName) {
        try {
            String currentEnvironment = String.join((CharSequence)",", this.environment.getActiveProfiles());
            this.sendMessage(content);
            HashMap<String, Object> emailSubParam = new HashMap<String, Object>(10);
            emailSubParam.put("%e%", new String[]{currentEnvironment});
            this.sendEmail(emailSubParam, templateInvokeName);
        }
        catch (Exception e) {
            log.error(" \u53d1\u9001\u544a\u8b66\u77ed\u4fe1\u5931\u8d25\uff01 ", (Throwable)e);
        }
    }

    @Override
    public void sendEmail(String hotelCode, String templateInvokeName) {
        try {
            boolean isProd = Arrays.stream(this.environment.getActiveProfiles()).anyMatch(env -> "prod".equalsIgnoreCase((String)env));
            String currentEnvironment = String.join((CharSequence)",", this.environment.getActiveProfiles());
            if (isProd) {
                HashMap<String, Object> emailSubParam = new HashMap<String, Object>(10);
                emailSubParam.put("%e%", new String[]{currentEnvironment});
                emailSubParam.put("%hotelCode%", new String[]{String.join((CharSequence)",", hotelCode)});
                this.sendEmail(emailSubParam, templateInvokeName);
            }
        }
        catch (Exception e) {
            log.error(" \u53d1\u9001\u544a\u8b66\u77ed\u4fe1\u5931\u8d25\uff01 ", (Throwable)e);
        }
    }

    private void sendEmail(Map<String, Object> emailSubParam, String templateInvokeName) {
        for (String to : this.emailTo.split(",")) {
            HashMap<String, Object> emailParam = new HashMap<String, Object>(10);
            emailParam.put("to", new String[]{to});
            emailParam.put("sub", emailSubParam);
            String xsmtApi = JSON.toJSONString(emailParam);
            String emailResult = this.alarmEmailClient.sendEmail(this.emailApiUser, this.emailApiKey, this.emailFrom, templateInvokeName, xsmtApi);
            if (!StringUtils.isNotBlank((CharSequence)emailResult)) continue;
            log.info(" mailResult: " + emailResult);
        }
    }

    @Override
    public void sendMessage(String content) {
        boolean isProd = Arrays.stream(this.environment.getActiveProfiles()).anyMatch(env -> "prod".equalsIgnoreCase((String)env));
        if (isProd) {
            String[] phoneArray;
            for (String aPhoneArray : phoneArray = this.smsPhones.split(",")) {
                String result = this.alarmSmsClient.sendSms(this.smsUsername, this.smsPassword, aPhoneArray, content);
                if (result.equals(ResultCode.SUCCESS.getCode() + "")) continue;
                log.error(" \u544a\u8b66\u77ed\u4fe1\u5931\u8d25\uff01 reuslt:" + result);
            }
        }
    }
}

