/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.custom;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigType;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.config.ConfigurationProvider;
import java.util.stream.Stream;

@LoadLevel(name="Custom")
public class CustomConfigurationProvider
implements ConfigurationProvider {
    public Configuration provide() {
        String pathDataId = "config." + ConfigType.Custom.name().toLowerCase() + "." + "name";
        String name = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig(pathDataId);
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name value of custom config type must not be blank");
        }
        if (Stream.of(ConfigType.values()).anyMatch(ct -> ct.name().equalsIgnoreCase(name))) {
            throw new IllegalArgumentException(String.format("custom config type name %s is not allowed", name));
        }
        return ((ConfigurationProvider)EnhancedServiceLoader.load(ConfigurationProvider.class, (String)name)).provide();
    }
}

