/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.context.RootContext;
import io.seata.rm.datasource.ConnectionProxy;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.Executor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.sqlparser.ParametersHolder;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.WhereRecognizer;
import io.seata.sqlparser.util.ColumnUtils;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseTransactionalExecutor<T, S extends Statement>
implements Executor<T> {
    private static final boolean ONLY_CARE_UPDATE_COLUMNS = ConfigurationFactory.getInstance().getBoolean("client.undo.onlyCareUpdateColumns", true);
    protected StatementProxy<S> statementProxy;
    protected StatementCallback<T, S> statementCallback;
    protected SQLRecognizer sqlRecognizer;
    protected List<SQLRecognizer> sqlRecognizers;
    private TableMeta tableMeta;

    public BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizer = sqlRecognizer;
    }

    public BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizers = sqlRecognizers;
    }

    @Override
    public T execute(Object ... args) throws Throwable {
        String xid = RootContext.getXID();
        if (xid != null) {
            this.statementProxy.getConnectionProxy().bind(xid);
        }
        this.statementProxy.getConnectionProxy().setGlobalLockRequire(RootContext.requireGlobalLock());
        return this.doExecute(args);
    }

    protected abstract T doExecute(Object ... var1) throws Throwable;

    protected String buildWhereCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String whereCondition = null;
        whereCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getWhereCondition((ParametersHolder)this.statementProxy, paramAppenderList) : recognizer.getWhereCondition();
        if (StringUtils.isNotBlank((String)whereCondition) && CollectionUtils.isNotEmpty(paramAppenderList) && paramAppenderList.size() > 1) {
            StringBuilder whereConditionSb = new StringBuilder();
            whereConditionSb.append(" ( ").append(whereCondition).append(" ) ");
            for (int i = 1; i < paramAppenderList.size(); ++i) {
                whereConditionSb.append(" or ( ").append(whereCondition).append(" ) ");
            }
            whereCondition = whereConditionSb.toString();
        }
        return whereCondition;
    }

    protected String buildOrderCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String orderByCondition = null;
        orderByCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getOrderByCondition((ParametersHolder)this.statementProxy, paramAppenderList) : recognizer.getOrderByCondition();
        return orderByCondition;
    }

    protected String buildLimitCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String limitCondition = null;
        limitCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getLimitCondition((ParametersHolder)this.statementProxy, paramAppenderList) : recognizer.getLimitCondition();
        return limitCondition;
    }

    protected String getColumnNameInSQL(String columnName) {
        String tableAlias = this.sqlRecognizer.getTableAlias();
        return tableAlias == null ? columnName : tableAlias + "." + columnName;
    }

    protected String getColumnNameWithTablePrefix(String table, String tableAlias, String columnName) {
        return tableAlias == null ? (table == null ? columnName : table + "." + columnName) : tableAlias + "." + columnName;
    }

    protected List<String> getColumnNamesWithTablePrefixList(String table, String tableAlias, List<String> columnNames) {
        ArrayList<String> columnNameWithTablePrefix = new ArrayList<String>();
        for (String columnName : columnNames) {
            columnNameWithTablePrefix.add(this.getColumnNameWithTablePrefix(table, tableAlias, columnName));
        }
        return columnNameWithTablePrefix;
    }

    protected String getColumnNamesInSQL(List<String> columnNameList) {
        if (CollectionUtils.isEmpty(columnNameList)) {
            return null;
        }
        StringBuilder columnNamesStr = new StringBuilder();
        for (int i = 0; i < columnNameList.size(); ++i) {
            if (i > 0) {
                columnNamesStr.append(" , ");
            }
            columnNamesStr.append(this.getColumnNameInSQL(columnNameList.get(i)));
        }
        return columnNamesStr.toString();
    }

    protected String getColumnNamesWithTablePrefix(String table, String tableAlias, List<String> columnNameList) {
        if (CollectionUtils.isEmpty(columnNameList)) {
            return null;
        }
        StringBuilder columnNamesStr = new StringBuilder();
        for (int i = 0; i < columnNameList.size(); ++i) {
            if (i > 0) {
                columnNamesStr.append(" , ");
            }
            columnNamesStr.append(this.getColumnNameWithTablePrefix(table, tableAlias, columnNameList.get(i)));
        }
        return columnNamesStr.toString();
    }

    protected String getFromTableInSQL() {
        String tableName = this.sqlRecognizer.getTableName();
        String tableAlias = this.sqlRecognizer.getTableAlias();
        return tableAlias == null ? tableName : tableName + " " + tableAlias;
    }

    protected TableMeta getTableMeta() {
        return this.getTableMeta(this.sqlRecognizer.getTableName());
    }

    protected TableMeta getTableMeta(String tableName) {
        if (this.tableMeta != null) {
            return this.tableMeta;
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        this.tableMeta = TableMetaCacheFactory.getTableMetaCache(connectionProxy.getDbType()).getTableMeta(connectionProxy.getTargetConnection(), tableName, connectionProxy.getDataSourceProxy().getResourceId());
        return this.tableMeta;
    }

    protected boolean containsPK(List<String> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return false;
        }
        List newColumns = ColumnUtils.delEscape(columns, (String)this.getDbType());
        return this.getTableMeta().containsPK(newColumns);
    }

    protected boolean containsPK(String tableName, List<String> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return false;
        }
        List newColumns = ColumnUtils.delEscape(columns, (String)this.getDbType());
        return this.getTableMeta(tableName).containsPK(newColumns);
    }

    protected boolean containPK(String columnName) {
        String newColumnName = ColumnUtils.delEscape((String)columnName, (String)this.getDbType());
        return CollectionUtils.toUpperList(this.getTableMeta().getPrimaryKeyOnlyName()).contains(newColumnName.toUpperCase());
    }

    protected String getStandardPkColumnName(String userColumnName) {
        String newUserColumnName = ColumnUtils.delEscape((String)userColumnName, (String)this.getDbType());
        for (String cn : this.getTableMeta().getPrimaryKeyOnlyName()) {
            if (!cn.equalsIgnoreCase(newUserColumnName)) continue;
            return cn;
        }
        return null;
    }

    protected void prepareUndoLog(TableRecords beforeImage, TableRecords afterImage) throws SQLException {
        if (beforeImage.getRows().isEmpty() && afterImage.getRows().isEmpty()) {
            return;
        }
        if (SQLType.UPDATE == this.sqlRecognizer.getSQLType() && beforeImage.getRows().size() != afterImage.getRows().size()) {
            throw new ShouldNeverHappenException("Before image size is not equaled to after image size, probably because you updated the primary keys.");
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        TableRecords lockKeyRecords = this.sqlRecognizer.getSQLType() == SQLType.DELETE ? beforeImage : afterImage;
        String lockKeys = this.buildLockKey(lockKeyRecords);
        if (null != lockKeys) {
            connectionProxy.appendLockKey(lockKeys);
            SQLUndoLog sqlUndoLog = this.buildUndoItem(beforeImage, afterImage);
            connectionProxy.appendUndoLog(sqlUndoLog);
        }
    }

    protected String buildLockKey(TableRecords rowsIncludingPK) {
        if (rowsIncludingPK.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rowsIncludingPK.getTableMeta().getTableName());
        sb.append(":");
        int rowSequence = 0;
        List<Map<String, Field>> pksRows = rowsIncludingPK.pkRows();
        List<String> primaryKeysOnlyName = rowsIncludingPK.getTableMeta().getPrimaryKeyOnlyName();
        for (Map<String, Field> rowMap : pksRows) {
            int pkSplitIndex = 0;
            for (String pkName : primaryKeysOnlyName) {
                if (pkSplitIndex > 0) {
                    sb.append("_");
                }
                sb.append(rowMap.get(pkName).getValue());
                ++pkSplitIndex;
            }
            if (++rowSequence >= pksRows.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected SQLUndoLog buildUndoItem(TableRecords beforeImage, TableRecords afterImage) {
        SQLType sqlType = this.sqlRecognizer.getSQLType();
        String tableName = this.sqlRecognizer.getTableName();
        SQLUndoLog sqlUndoLog = new SQLUndoLog();
        sqlUndoLog.setSqlType(sqlType);
        sqlUndoLog.setTableName(tableName);
        sqlUndoLog.setBeforeImage(beforeImage);
        sqlUndoLog.setAfterImage(afterImage);
        return sqlUndoLog;
    }

    /*
     * Exception decompiling
     */
    protected TableRecords buildTableRecords(TableMeta tableMeta, String selectSQL, ArrayList<List<Object>> paramAppenderList) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected TableRecords buildTableRecords(Map<String, List<Object>> pkValuesMap) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getDbType() {
        return this.statementProxy.getConnectionProxy().getDbType();
    }
}

