/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.util.NumberUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.context.GlobalLockConfigHolder;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.GlobalLockConfig;
import io.seata.rm.datasource.exec.LockConflictException;
import io.seata.rm.datasource.exec.LockWaitTimeoutException;

public class LockRetryController {
    private static final GlobalConfig LISTENER = new GlobalConfig();
    private int lockRetryInterval = this.getLockRetryInterval();
    private int lockRetryTimes = this.getLockRetryTimes();

    public void sleep(Exception e) throws LockWaitTimeoutException {
        if (--this.lockRetryTimes < 0 || e instanceof LockConflictException && ((LockConflictException)e).getCode() == TransactionExceptionCode.LockKeyConflictFailFast) {
            throw new LockWaitTimeoutException("Global lock wait timeout", e);
        }
        try {
            Thread.sleep(this.lockRetryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    int getLockRetryInterval() {
        int configInterval;
        GlobalLockConfig config = GlobalLockConfigHolder.getCurrentGlobalLockConfig();
        if (config != null && (configInterval = config.getLockRetryInterval()) > 0) {
            return configInterval;
        }
        return LISTENER.getGlobalLockRetryInterval();
    }

    int getLockRetryTimes() {
        int configTimes;
        GlobalLockConfig config = GlobalLockConfigHolder.getCurrentGlobalLockConfig();
        if (config != null && (configTimes = config.getLockRetryTimes()) >= 0) {
            return configTimes;
        }
        return LISTENER.getGlobalLockRetryTimes();
    }

    static {
        ConfigurationCache.addConfigListener((String)"client.rm.lock.retryInterval", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{LISTENER});
        ConfigurationCache.addConfigListener((String)"client.rm.lock.retryTimes", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{LISTENER});
    }

    static class GlobalConfig
    implements ConfigurationChangeListener {
        private volatile int globalLockRetryInterval;
        private volatile int globalLockRetryTimes;
        private final int defaultRetryInterval = 10;
        private final int defaultRetryTimes = 30;

        public GlobalConfig() {
            Configuration configuration = ConfigurationFactory.getInstance();
            this.globalLockRetryInterval = configuration.getInt("client.rm.lock.retryInterval", 10);
            this.globalLockRetryTimes = configuration.getInt("client.rm.lock.retryTimes", 30);
        }

        public void onChangeEvent(ConfigurationChangeEvent event) {
            String dataId = event.getDataId();
            String newValue = event.getNewValue();
            if ("client.rm.lock.retryInterval".equals(dataId)) {
                this.globalLockRetryInterval = NumberUtils.toInt((String)newValue, (int)10);
            }
            if ("client.rm.lock.retryTimes".equals(dataId)) {
                this.globalLockRetryTimes = NumberUtils.toInt((String)newValue, (int)30);
            }
        }

        public int getGlobalLockRetryInterval() {
            return this.globalLockRetryInterval;
        }

        public int getGlobalLockRetryTimes() {
            return this.globalLockRetryTimes;
        }
    }
}

